/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for AllocationShareSettings.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AllocationShareSettings extends com.google.api.client.json.GenericJson {

  /**
   * A List of Project names to specify consumer projects for this shared-reservation. This is only
   * valid when share_type's value is SPECIFIC_PROJECTS.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> projects;

  /**
   * Type of sharing for this shared-reservation
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String shareType;

  /**
   * A List of Project names to specify consumer projects for this shared-reservation. This is only
   * valid when share_type's value is SPECIFIC_PROJECTS.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getProjects() {
    return projects;
  }

  /**
   * A List of Project names to specify consumer projects for this shared-reservation. This is only
   * valid when share_type's value is SPECIFIC_PROJECTS.
   * @param projects projects or {@code null} for none
   */
  public AllocationShareSettings setProjects(java.util.List<java.lang.String> projects) {
    this.projects = projects;
    return this;
  }

  /**
   * Type of sharing for this shared-reservation
   * @return value or {@code null} for none
   */
  public java.lang.String getShareType() {
    return shareType;
  }

  /**
   * Type of sharing for this shared-reservation
   * @param shareType shareType or {@code null} for none
   */
  public AllocationShareSettings setShareType(java.lang.String shareType) {
    this.shareType = shareType;
    return this;
  }

  @Override
  public AllocationShareSettings set(String fieldName, Object value) {
    return (AllocationShareSettings) super.set(fieldName, value);
  }

  @Override
  public AllocationShareSettings clone() {
    return (AllocationShareSettings) super.clone();
  }

}
