/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for ResourceStatusScheduling.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ResourceStatusScheduling extends com.google.api.client.json.GenericJson {

  /**
   * Specifies the availability domain (AD), which this instance should be scheduled on. The AD
   * belongs to the spread GroupPlacementPolicy resource policy that has been assigned to the
   * instance. Specify a value between 1-max count of availability domains in your
   * GroupPlacementPolicy. See go/placement-policy-extension for more details.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer availabilityDomain;

  /**
   * Specifies the availability domain (AD), which this instance should be scheduled on. The AD
   * belongs to the spread GroupPlacementPolicy resource policy that has been assigned to the
   * instance. Specify a value between 1-max count of availability domains in your
   * GroupPlacementPolicy. See go/placement-policy-extension for more details.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getAvailabilityDomain() {
    return availabilityDomain;
  }

  /**
   * Specifies the availability domain (AD), which this instance should be scheduled on. The AD
   * belongs to the spread GroupPlacementPolicy resource policy that has been assigned to the
   * instance. Specify a value between 1-max count of availability domains in your
   * GroupPlacementPolicy. See go/placement-policy-extension for more details.
   * @param availabilityDomain availabilityDomain or {@code null} for none
   */
  public ResourceStatusScheduling setAvailabilityDomain(java.lang.Integer availabilityDomain) {
    this.availabilityDomain = availabilityDomain;
    return this;
  }

  @Override
  public ResourceStatusScheduling set(String fieldName, Object value) {
    return (ResourceStatusScheduling) super.set(fieldName, value);
  }

  @Override
  public ResourceStatusScheduling clone() {
    return (ResourceStatusScheduling) super.clone();
  }

}
