/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * A transient resource used in compute.regionInstances.recommendLocations. This resource is not
 * saved anywhere and used only to process the request.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RegionInstancesRecommendLocationsResource extends com.google.api.client.json.GenericJson {

  /**
   * Specification of named homogeneous instance sets to find location for. Keys of this map are
   * arbitrary (but must be different), defined by the caller used only in the response. They must
   * follow RFC 1035 name standard. Specifically, they must be 1-63 characters long and match the
   * regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a
   * lowercase letter, and all following characters must be a dash, lowercase letter, or digit,
   * except the last character, which cannot be a dash. Values are trimmed
   * BulkInsertInstanceResource messages, without the following fields:   - min_count -
   * predefined_name - name_pattern - per_instance_properties - instance - secure_tag -
   * location_policy
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, BulkInsertInstanceResource> instanceSpecs;

  static {
    // hack to force ProGuard to consider BulkInsertInstanceResource used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(BulkInsertInstanceResource.class);
  }

  /**
   * Location policy to indicate allowed zones for instances, together with the shape of the
   * distribution.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocationPolicy locationPolicy;

  /**
   * Specification of named homogeneous instance sets to find location for. Keys of this map are
   * arbitrary (but must be different), defined by the caller used only in the response. They must
   * follow RFC 1035 name standard. Specifically, they must be 1-63 characters long and match the
   * regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a
   * lowercase letter, and all following characters must be a dash, lowercase letter, or digit,
   * except the last character, which cannot be a dash. Values are trimmed
   * BulkInsertInstanceResource messages, without the following fields:   - min_count -
   * predefined_name - name_pattern - per_instance_properties - instance - secure_tag -
   * location_policy
   * @return value or {@code null} for none
   */
  public java.util.Map<String, BulkInsertInstanceResource> getInstanceSpecs() {
    return instanceSpecs;
  }

  /**
   * Specification of named homogeneous instance sets to find location for. Keys of this map are
   * arbitrary (but must be different), defined by the caller used only in the response. They must
   * follow RFC 1035 name standard. Specifically, they must be 1-63 characters long and match the
   * regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a
   * lowercase letter, and all following characters must be a dash, lowercase letter, or digit,
   * except the last character, which cannot be a dash. Values are trimmed
   * BulkInsertInstanceResource messages, without the following fields:   - min_count -
   * predefined_name - name_pattern - per_instance_properties - instance - secure_tag -
   * location_policy
   * @param instanceSpecs instanceSpecs or {@code null} for none
   */
  public RegionInstancesRecommendLocationsResource setInstanceSpecs(java.util.Map<String, BulkInsertInstanceResource> instanceSpecs) {
    this.instanceSpecs = instanceSpecs;
    return this;
  }

  /**
   * Location policy to indicate allowed zones for instances, together with the shape of the
   * distribution.
   * @return value or {@code null} for none
   */
  public LocationPolicy getLocationPolicy() {
    return locationPolicy;
  }

  /**
   * Location policy to indicate allowed zones for instances, together with the shape of the
   * distribution.
   * @param locationPolicy locationPolicy or {@code null} for none
   */
  public RegionInstancesRecommendLocationsResource setLocationPolicy(LocationPolicy locationPolicy) {
    this.locationPolicy = locationPolicy;
    return this;
  }

  @Override
  public RegionInstancesRecommendLocationsResource set(String fieldName, Object value) {
    return (RegionInstancesRecommendLocationsResource) super.set(fieldName, value);
  }

  @Override
  public RegionInstancesRecommendLocationsResource clone() {
    return (RegionInstancesRecommendLocationsResource) super.clone();
  }

}
