/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for InstanceConsumptionData.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InstanceConsumptionData extends com.google.api.client.json.GenericJson {

  /**
   * Resources consumed by the instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InstanceConsumptionInfo consumptionInfo;

  /**
   * Server-defined URL for the instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String instance;

  /**
   * Resources consumed by the instance.
   * @return value or {@code null} for none
   */
  public InstanceConsumptionInfo getConsumptionInfo() {
    return consumptionInfo;
  }

  /**
   * Resources consumed by the instance.
   * @param consumptionInfo consumptionInfo or {@code null} for none
   */
  public InstanceConsumptionData setConsumptionInfo(InstanceConsumptionInfo consumptionInfo) {
    this.consumptionInfo = consumptionInfo;
    return this;
  }

  /**
   * Server-defined URL for the instance.
   * @return value or {@code null} for none
   */
  public java.lang.String getInstance() {
    return instance;
  }

  /**
   * Server-defined URL for the instance.
   * @param instance instance or {@code null} for none
   */
  public InstanceConsumptionData setInstance(java.lang.String instance) {
    this.instance = instance;
    return this;
  }

  @Override
  public InstanceConsumptionData set(String fieldName, Object value) {
    return (InstanceConsumptionData) super.set(fieldName, value);
  }

  @Override
  public InstanceConsumptionData clone() {
    return (InstanceConsumptionData) super.clone();
  }

}
