/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for InstanceGroupManagerInstanceLifecyclePolicy.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InstanceGroupManagerInstanceLifecyclePolicy extends com.google.api.client.json.GenericJson {

  /**
   * A bit indicating whether to forcefully apply the group's latest configuration when repairing a
   * VM. Valid options are: - NO (default): If configuration updates are available, they are not
   * forcefully applied during repair. However, if you've set up a proactive type of update policy,
   * then configuration updates are applied as usual. - YES: If configuration updates are available,
   * they are applied during repair.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String forceUpdateOnRepair;

  /**
   * The configuration for metadata based readiness signal sent by the instance during
   * initialization when stopping / suspending an instance. The Instance Group Manager will wait for
   * a signal that indicates successful initialization before stopping / suspending an instance. If
   * a successful readiness signal is not sent before timeout, the corresponding instance will not
   * be stopped / suspended. Instead, an error will be visible in the lastAttempt.errors field of
   * the managed instance in the listmanagedinstances method. If
   * metadataBasedReadinessSignal.timeoutSec is unset, the Instance Group Manager will directly
   * proceed to suspend / stop instances, skipping initialization on them.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InstanceGroupManagerInstanceLifecyclePolicyMetadataBasedReadinessSignal metadataBasedReadinessSignal;

  /**
   * A bit indicating whether to forcefully apply the group's latest configuration when repairing a
   * VM. Valid options are: - NO (default): If configuration updates are available, they are not
   * forcefully applied during repair. However, if you've set up a proactive type of update policy,
   * then configuration updates are applied as usual. - YES: If configuration updates are available,
   * they are applied during repair.
   * @return value or {@code null} for none
   */
  public java.lang.String getForceUpdateOnRepair() {
    return forceUpdateOnRepair;
  }

  /**
   * A bit indicating whether to forcefully apply the group's latest configuration when repairing a
   * VM. Valid options are: - NO (default): If configuration updates are available, they are not
   * forcefully applied during repair. However, if you've set up a proactive type of update policy,
   * then configuration updates are applied as usual. - YES: If configuration updates are available,
   * they are applied during repair.
   * @param forceUpdateOnRepair forceUpdateOnRepair or {@code null} for none
   */
  public InstanceGroupManagerInstanceLifecyclePolicy setForceUpdateOnRepair(java.lang.String forceUpdateOnRepair) {
    this.forceUpdateOnRepair = forceUpdateOnRepair;
    return this;
  }

  /**
   * The configuration for metadata based readiness signal sent by the instance during
   * initialization when stopping / suspending an instance. The Instance Group Manager will wait for
   * a signal that indicates successful initialization before stopping / suspending an instance. If
   * a successful readiness signal is not sent before timeout, the corresponding instance will not
   * be stopped / suspended. Instead, an error will be visible in the lastAttempt.errors field of
   * the managed instance in the listmanagedinstances method. If
   * metadataBasedReadinessSignal.timeoutSec is unset, the Instance Group Manager will directly
   * proceed to suspend / stop instances, skipping initialization on them.
   * @return value or {@code null} for none
   */
  public InstanceGroupManagerInstanceLifecyclePolicyMetadataBasedReadinessSignal getMetadataBasedReadinessSignal() {
    return metadataBasedReadinessSignal;
  }

  /**
   * The configuration for metadata based readiness signal sent by the instance during
   * initialization when stopping / suspending an instance. The Instance Group Manager will wait for
   * a signal that indicates successful initialization before stopping / suspending an instance. If
   * a successful readiness signal is not sent before timeout, the corresponding instance will not
   * be stopped / suspended. Instead, an error will be visible in the lastAttempt.errors field of
   * the managed instance in the listmanagedinstances method. If
   * metadataBasedReadinessSignal.timeoutSec is unset, the Instance Group Manager will directly
   * proceed to suspend / stop instances, skipping initialization on them.
   * @param metadataBasedReadinessSignal metadataBasedReadinessSignal or {@code null} for none
   */
  public InstanceGroupManagerInstanceLifecyclePolicy setMetadataBasedReadinessSignal(InstanceGroupManagerInstanceLifecyclePolicyMetadataBasedReadinessSignal metadataBasedReadinessSignal) {
    this.metadataBasedReadinessSignal = metadataBasedReadinessSignal;
    return this;
  }

  @Override
  public InstanceGroupManagerInstanceLifecyclePolicy set(String fieldName, Object value) {
    return (InstanceGroupManagerInstanceLifecyclePolicy) super.set(fieldName, value);
  }

  @Override
  public InstanceGroupManagerInstanceLifecyclePolicy clone() {
    return (InstanceGroupManagerInstanceLifecyclePolicy) super.clone();
  }

}
