/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Upcoming Maintenance notification information. TODO(b/196881882) Deprecate this proto once it's
 * fully migrated to be under proto ResourceStatus.UpcomingMaintenance.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UpcomingMaintenance extends com.google.api.client.json.GenericJson {

  /**
   * Indicates if the maintenance can be customer triggered. From more detail, see go/sf-ctm-design.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean canReschedule;

  /**
   * [Output Only] The date when the maintenance will take place. This value is in RFC3339 text
   * format. DEPRECATED: Use start_time_window instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String date;

  /**
   * [Output Only] The start time window of the maintenance disruption.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UpcomingMaintenanceTimeWindow startTimeWindow;

  /**
   * [Output Only] The time when the maintenance will take place. This value is in RFC3339 text
   * format. DEPRECATED: Use start_time_window instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String time;

  /**
   * Defines the type of maintenance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Indicates if the maintenance can be customer triggered. From more detail, see go/sf-ctm-design.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getCanReschedule() {
    return canReschedule;
  }

  /**
   * Indicates if the maintenance can be customer triggered. From more detail, see go/sf-ctm-design.
   * @param canReschedule canReschedule or {@code null} for none
   */
  public UpcomingMaintenance setCanReschedule(java.lang.Boolean canReschedule) {
    this.canReschedule = canReschedule;
    return this;
  }

  /**
   * [Output Only] The date when the maintenance will take place. This value is in RFC3339 text
   * format. DEPRECATED: Use start_time_window instead.
   * @return value or {@code null} for none
   */
  public java.lang.String getDate() {
    return date;
  }

  /**
   * [Output Only] The date when the maintenance will take place. This value is in RFC3339 text
   * format. DEPRECATED: Use start_time_window instead.
   * @param date date or {@code null} for none
   */
  public UpcomingMaintenance setDate(java.lang.String date) {
    this.date = date;
    return this;
  }

  /**
   * [Output Only] The start time window of the maintenance disruption.
   * @return value or {@code null} for none
   */
  public UpcomingMaintenanceTimeWindow getStartTimeWindow() {
    return startTimeWindow;
  }

  /**
   * [Output Only] The start time window of the maintenance disruption.
   * @param startTimeWindow startTimeWindow or {@code null} for none
   */
  public UpcomingMaintenance setStartTimeWindow(UpcomingMaintenanceTimeWindow startTimeWindow) {
    this.startTimeWindow = startTimeWindow;
    return this;
  }

  /**
   * [Output Only] The time when the maintenance will take place. This value is in RFC3339 text
   * format. DEPRECATED: Use start_time_window instead.
   * @return value or {@code null} for none
   */
  public java.lang.String getTime() {
    return time;
  }

  /**
   * [Output Only] The time when the maintenance will take place. This value is in RFC3339 text
   * format. DEPRECATED: Use start_time_window instead.
   * @param time time or {@code null} for none
   */
  public UpcomingMaintenance setTime(java.lang.String time) {
    this.time = time;
    return this;
  }

  /**
   * Defines the type of maintenance.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Defines the type of maintenance.
   * @param type type or {@code null} for none
   */
  public UpcomingMaintenance setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public UpcomingMaintenance set(String fieldName, Object value) {
    return (UpcomingMaintenance) super.set(fieldName, value);
  }

  @Override
  public UpcomingMaintenance clone() {
    return (UpcomingMaintenance) super.clone();
  }

}
