/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Represents a rule that describes one or more match conditions along with the action to be taken
 * when traffic matches this condition (allow or deny).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FirewallPolicyRule extends com.google.api.client.json.GenericJson {

  /**
   * The Action to perform when the client connection triggers the rule. Can currently be either
   * "allow" or "deny()" where valid values for status are 403, 404, and 502.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String action;

  /**
   * An optional description for this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * The direction in which this rule applies.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String direction;

  /**
   * Denotes whether the firewall policy rule is disabled. When set to true, the firewall policy
   * rule is not enforced and traffic behaves as if it did not exist. If this is unspecified, the
   * firewall policy rule will be enabled.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean disabled;

  /**
   * Denotes whether to enable logging for a particular rule. If logging is enabled, logs will be
   * exported to the configured export destination in Stackdriver. Logs may be exported to BigQuery
   * or Pub/Sub. Note: you cannot enable logging on "goto_next" rules.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean enableLogging;

  /**
   * [Output only] Type of the resource. Always compute#firewallPolicyRule for firewall policy rules
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * A match condition that incoming traffic is evaluated against. If it evaluates to true, the
   * corresponding 'action' is enforced.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FirewallPolicyRuleMatcher match;

  /**
   * An integer indicating the priority of a rule in the list. The priority must be a positive value
   * between 0 and 2147483647. Rules are evaluated from highest to lowest priority where 0 is the
   * highest priority and 2147483647 is the lowest prority.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer priority;

  /**
   * An optional name for the rule. This field is not a unique identifier and can be updated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ruleName;

  /**
   * [Output Only] Calculation of the complexity of a single firewall policy rule.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer ruleTupleCount;

  /**
   * A fully-qualified URL of a SecurityProfile resource instance. Example: https://networksecurity.
   * googleapis.com/v1/projects/{project}/locations/{location}/securityProfileGroups/my-security-
   * profile-group Must be specified if action = 'apply_security_profile_group' and cannot be
   * specified for other actions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String securityProfileGroup;

  /**
   * A list of network resource URLs to which this rule applies. This field allows you to control
   * which network's VMs get this rule. If this field is left blank, all VMs within the organization
   * will receive the rule.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> targetResources;

  /**
   * A list of secure tags that controls which instances the firewall rule applies to. If
   * targetSecureTag are specified, then the firewall rule applies only to instances in the VPC
   * network that have one of those EFFECTIVE secure tags, if all the target_secure_tag are in
   * INEFFECTIVE state, then this rule will be ignored. targetSecureTag may not be set at the same
   * time as targetServiceAccounts. If neither targetServiceAccounts nor targetSecureTag are
   * specified, the firewall rule applies to all instances on the specified network. Maximum number
   * of target label tags allowed is 256.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<FirewallPolicyRuleSecureTag> targetSecureTags;

  /**
   * A list of service accounts indicating the sets of instances that are applied with this rule.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> targetServiceAccounts;

  /**
   * The Action to perform when the client connection triggers the rule. Can currently be either
   * "allow" or "deny()" where valid values for status are 403, 404, and 502.
   * @return value or {@code null} for none
   */
  public java.lang.String getAction() {
    return action;
  }

  /**
   * The Action to perform when the client connection triggers the rule. Can currently be either
   * "allow" or "deny()" where valid values for status are 403, 404, and 502.
   * @param action action or {@code null} for none
   */
  public FirewallPolicyRule setAction(java.lang.String action) {
    this.action = action;
    return this;
  }

  /**
   * An optional description for this resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional description for this resource.
   * @param description description or {@code null} for none
   */
  public FirewallPolicyRule setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * The direction in which this rule applies.
   * @return value or {@code null} for none
   */
  public java.lang.String getDirection() {
    return direction;
  }

  /**
   * The direction in which this rule applies.
   * @param direction direction or {@code null} for none
   */
  public FirewallPolicyRule setDirection(java.lang.String direction) {
    this.direction = direction;
    return this;
  }

  /**
   * Denotes whether the firewall policy rule is disabled. When set to true, the firewall policy
   * rule is not enforced and traffic behaves as if it did not exist. If this is unspecified, the
   * firewall policy rule will be enabled.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDisabled() {
    return disabled;
  }

  /**
   * Denotes whether the firewall policy rule is disabled. When set to true, the firewall policy
   * rule is not enforced and traffic behaves as if it did not exist. If this is unspecified, the
   * firewall policy rule will be enabled.
   * @param disabled disabled or {@code null} for none
   */
  public FirewallPolicyRule setDisabled(java.lang.Boolean disabled) {
    this.disabled = disabled;
    return this;
  }

  /**
   * Denotes whether to enable logging for a particular rule. If logging is enabled, logs will be
   * exported to the configured export destination in Stackdriver. Logs may be exported to BigQuery
   * or Pub/Sub. Note: you cannot enable logging on "goto_next" rules.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEnableLogging() {
    return enableLogging;
  }

  /**
   * Denotes whether to enable logging for a particular rule. If logging is enabled, logs will be
   * exported to the configured export destination in Stackdriver. Logs may be exported to BigQuery
   * or Pub/Sub. Note: you cannot enable logging on "goto_next" rules.
   * @param enableLogging enableLogging or {@code null} for none
   */
  public FirewallPolicyRule setEnableLogging(java.lang.Boolean enableLogging) {
    this.enableLogging = enableLogging;
    return this;
  }

  /**
   * [Output only] Type of the resource. Always compute#firewallPolicyRule for firewall policy rules
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output only] Type of the resource. Always compute#firewallPolicyRule for firewall policy rules
   * @param kind kind or {@code null} for none
   */
  public FirewallPolicyRule setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * A match condition that incoming traffic is evaluated against. If it evaluates to true, the
   * corresponding 'action' is enforced.
   * @return value or {@code null} for none
   */
  public FirewallPolicyRuleMatcher getMatch() {
    return match;
  }

  /**
   * A match condition that incoming traffic is evaluated against. If it evaluates to true, the
   * corresponding 'action' is enforced.
   * @param match match or {@code null} for none
   */
  public FirewallPolicyRule setMatch(FirewallPolicyRuleMatcher match) {
    this.match = match;
    return this;
  }

  /**
   * An integer indicating the priority of a rule in the list. The priority must be a positive value
   * between 0 and 2147483647. Rules are evaluated from highest to lowest priority where 0 is the
   * highest priority and 2147483647 is the lowest prority.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getPriority() {
    return priority;
  }

  /**
   * An integer indicating the priority of a rule in the list. The priority must be a positive value
   * between 0 and 2147483647. Rules are evaluated from highest to lowest priority where 0 is the
   * highest priority and 2147483647 is the lowest prority.
   * @param priority priority or {@code null} for none
   */
  public FirewallPolicyRule setPriority(java.lang.Integer priority) {
    this.priority = priority;
    return this;
  }

  /**
   * An optional name for the rule. This field is not a unique identifier and can be updated.
   * @return value or {@code null} for none
   */
  public java.lang.String getRuleName() {
    return ruleName;
  }

  /**
   * An optional name for the rule. This field is not a unique identifier and can be updated.
   * @param ruleName ruleName or {@code null} for none
   */
  public FirewallPolicyRule setRuleName(java.lang.String ruleName) {
    this.ruleName = ruleName;
    return this;
  }

  /**
   * [Output Only] Calculation of the complexity of a single firewall policy rule.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getRuleTupleCount() {
    return ruleTupleCount;
  }

  /**
   * [Output Only] Calculation of the complexity of a single firewall policy rule.
   * @param ruleTupleCount ruleTupleCount or {@code null} for none
   */
  public FirewallPolicyRule setRuleTupleCount(java.lang.Integer ruleTupleCount) {
    this.ruleTupleCount = ruleTupleCount;
    return this;
  }

  /**
   * A fully-qualified URL of a SecurityProfile resource instance. Example: https://networksecurity.
   * googleapis.com/v1/projects/{project}/locations/{location}/securityProfileGroups/my-security-
   * profile-group Must be specified if action = 'apply_security_profile_group' and cannot be
   * specified for other actions.
   * @return value or {@code null} for none
   */
  public java.lang.String getSecurityProfileGroup() {
    return securityProfileGroup;
  }

  /**
   * A fully-qualified URL of a SecurityProfile resource instance. Example: https://networksecurity.
   * googleapis.com/v1/projects/{project}/locations/{location}/securityProfileGroups/my-security-
   * profile-group Must be specified if action = 'apply_security_profile_group' and cannot be
   * specified for other actions.
   * @param securityProfileGroup securityProfileGroup or {@code null} for none
   */
  public FirewallPolicyRule setSecurityProfileGroup(java.lang.String securityProfileGroup) {
    this.securityProfileGroup = securityProfileGroup;
    return this;
  }

  /**
   * A list of network resource URLs to which this rule applies. This field allows you to control
   * which network's VMs get this rule. If this field is left blank, all VMs within the organization
   * will receive the rule.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getTargetResources() {
    return targetResources;
  }

  /**
   * A list of network resource URLs to which this rule applies. This field allows you to control
   * which network's VMs get this rule. If this field is left blank, all VMs within the organization
   * will receive the rule.
   * @param targetResources targetResources or {@code null} for none
   */
  public FirewallPolicyRule setTargetResources(java.util.List<java.lang.String> targetResources) {
    this.targetResources = targetResources;
    return this;
  }

  /**
   * A list of secure tags that controls which instances the firewall rule applies to. If
   * targetSecureTag are specified, then the firewall rule applies only to instances in the VPC
   * network that have one of those EFFECTIVE secure tags, if all the target_secure_tag are in
   * INEFFECTIVE state, then this rule will be ignored. targetSecureTag may not be set at the same
   * time as targetServiceAccounts. If neither targetServiceAccounts nor targetSecureTag are
   * specified, the firewall rule applies to all instances on the specified network. Maximum number
   * of target label tags allowed is 256.
   * @return value or {@code null} for none
   */
  public java.util.List<FirewallPolicyRuleSecureTag> getTargetSecureTags() {
    return targetSecureTags;
  }

  /**
   * A list of secure tags that controls which instances the firewall rule applies to. If
   * targetSecureTag are specified, then the firewall rule applies only to instances in the VPC
   * network that have one of those EFFECTIVE secure tags, if all the target_secure_tag are in
   * INEFFECTIVE state, then this rule will be ignored. targetSecureTag may not be set at the same
   * time as targetServiceAccounts. If neither targetServiceAccounts nor targetSecureTag are
   * specified, the firewall rule applies to all instances on the specified network. Maximum number
   * of target label tags allowed is 256.
   * @param targetSecureTags targetSecureTags or {@code null} for none
   */
  public FirewallPolicyRule setTargetSecureTags(java.util.List<FirewallPolicyRuleSecureTag> targetSecureTags) {
    this.targetSecureTags = targetSecureTags;
    return this;
  }

  /**
   * A list of service accounts indicating the sets of instances that are applied with this rule.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getTargetServiceAccounts() {
    return targetServiceAccounts;
  }

  /**
   * A list of service accounts indicating the sets of instances that are applied with this rule.
   * @param targetServiceAccounts targetServiceAccounts or {@code null} for none
   */
  public FirewallPolicyRule setTargetServiceAccounts(java.util.List<java.lang.String> targetServiceAccounts) {
    this.targetServiceAccounts = targetServiceAccounts;
    return this;
  }

  @Override
  public FirewallPolicyRule set(String fieldName, Object value) {
    return (FirewallPolicyRule) super.set(fieldName, value);
  }

  @Override
  public FirewallPolicyRule clone() {
    return (FirewallPolicyRule) super.clone();
  }

}
