/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for InstancesSetNameRequest.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InstancesSetNameRequest extends com.google.api.client.json.GenericJson {

  /**
   * The current name of this resource, used to prevent conflicts. Provide the latest name when
   * making a request to change name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String currentName;

  /**
   * The name to be applied to the instance. Needs to be RFC 1035 compliant.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The current name of this resource, used to prevent conflicts. Provide the latest name when
   * making a request to change name.
   * @return value or {@code null} for none
   */
  public java.lang.String getCurrentName() {
    return currentName;
  }

  /**
   * The current name of this resource, used to prevent conflicts. Provide the latest name when
   * making a request to change name.
   * @param currentName currentName or {@code null} for none
   */
  public InstancesSetNameRequest setCurrentName(java.lang.String currentName) {
    this.currentName = currentName;
    return this;
  }

  /**
   * The name to be applied to the instance. Needs to be RFC 1035 compliant.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name to be applied to the instance. Needs to be RFC 1035 compliant.
   * @param name name or {@code null} for none
   */
  public InstancesSetNameRequest setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  @Override
  public InstancesSetNameRequest set(String fieldName, Object value) {
    return (InstancesSetNameRequest) super.set(fieldName, value);
  }

  @Override
  public InstancesSetNameRequest clone() {
    return (InstancesSetNameRequest) super.clone();
  }

}
