/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Contains output only fields. Use this sub-message for actual values set on Instance attributes as
 * compared to the value requested by the user (intent) in their instance CRUD calls.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ResourceStatus extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] An opaque ID of the host on which the VM is running.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String physicalHost;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ResourceStatusScheduling scheduling;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ResourceStatusUpcomingMaintenance upcomingMaintenance;

  /**
   * [Output Only] An opaque ID of the host on which the VM is running.
   * @return value or {@code null} for none
   */
  public java.lang.String getPhysicalHost() {
    return physicalHost;
  }

  /**
   * [Output Only] An opaque ID of the host on which the VM is running.
   * @param physicalHost physicalHost or {@code null} for none
   */
  public ResourceStatus setPhysicalHost(java.lang.String physicalHost) {
    this.physicalHost = physicalHost;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public ResourceStatusScheduling getScheduling() {
    return scheduling;
  }

  /**
   * @param scheduling scheduling or {@code null} for none
   */
  public ResourceStatus setScheduling(ResourceStatusScheduling scheduling) {
    this.scheduling = scheduling;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public ResourceStatusUpcomingMaintenance getUpcomingMaintenance() {
    return upcomingMaintenance;
  }

  /**
   * @param upcomingMaintenance upcomingMaintenance or {@code null} for none
   */
  public ResourceStatus setUpcomingMaintenance(ResourceStatusUpcomingMaintenance upcomingMaintenance) {
    this.upcomingMaintenance = upcomingMaintenance;
    return this;
  }

  @Override
  public ResourceStatus set(String fieldName, Object value) {
    return (ResourceStatus) super.set(fieldName, value);
  }

  @Override
  public ResourceStatus clone() {
    return (ResourceStatus) super.clone();
  }

}
