/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Represents the network information between workload placements.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CapacityConstraint extends com.google.api.client.json.GenericJson {

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String constraintMetadata;

  /**
   * Weighted sum of BandwidthTerms (each term is coefficient * term) must be less than or equal to
   * max_sum.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double maxSumGbps;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<CapacityConstraintConstraintTerm> terms;

  /**
   * @return value or {@code null} for none
   */
  public java.lang.String getConstraintMetadata() {
    return constraintMetadata;
  }

  /**
   * @param constraintMetadata constraintMetadata or {@code null} for none
   */
  public CapacityConstraint setConstraintMetadata(java.lang.String constraintMetadata) {
    this.constraintMetadata = constraintMetadata;
    return this;
  }

  /**
   * Weighted sum of BandwidthTerms (each term is coefficient * term) must be less than or equal to
   * max_sum.
   * @return value or {@code null} for none
   */
  public java.lang.Double getMaxSumGbps() {
    return maxSumGbps;
  }

  /**
   * Weighted sum of BandwidthTerms (each term is coefficient * term) must be less than or equal to
   * max_sum.
   * @param maxSumGbps maxSumGbps or {@code null} for none
   */
  public CapacityConstraint setMaxSumGbps(java.lang.Double maxSumGbps) {
    this.maxSumGbps = maxSumGbps;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.util.List<CapacityConstraintConstraintTerm> getTerms() {
    return terms;
  }

  /**
   * @param terms terms or {@code null} for none
   */
  public CapacityConstraint setTerms(java.util.List<CapacityConstraintConstraintTerm> terms) {
    this.terms = terms;
    return this;
  }

  @Override
  public CapacityConstraint set(String fieldName, Object value) {
    return (CapacityConstraint) super.set(fieldName, value);
  }

  @Override
  public CapacityConstraint clone() {
    return (CapacityConstraint) super.clone();
  }

}
