/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for CapacityConstraintConstraintTerm.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CapacityConstraintConstraintTerm extends com.google.api.client.json.GenericJson {

  /**
   * Coefficient of this term in the linear expression. The value of the term will be coefficient *
   * (demand from src to dst in Gbps).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double coefficient;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PlacementLocation destinationNode;

  /**
   * Source and destination nodes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PlacementLocation sourceNode;

  /**
   * Coefficient of this term in the linear expression. The value of the term will be coefficient *
   * (demand from src to dst in Gbps).
   * @return value or {@code null} for none
   */
  public java.lang.Double getCoefficient() {
    return coefficient;
  }

  /**
   * Coefficient of this term in the linear expression. The value of the term will be coefficient *
   * (demand from src to dst in Gbps).
   * @param coefficient coefficient or {@code null} for none
   */
  public CapacityConstraintConstraintTerm setCoefficient(java.lang.Double coefficient) {
    this.coefficient = coefficient;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public PlacementLocation getDestinationNode() {
    return destinationNode;
  }

  /**
   * @param destinationNode destinationNode or {@code null} for none
   */
  public CapacityConstraintConstraintTerm setDestinationNode(PlacementLocation destinationNode) {
    this.destinationNode = destinationNode;
    return this;
  }

  /**
   * Source and destination nodes.
   * @return value or {@code null} for none
   */
  public PlacementLocation getSourceNode() {
    return sourceNode;
  }

  /**
   * Source and destination nodes.
   * @param sourceNode sourceNode or {@code null} for none
   */
  public CapacityConstraintConstraintTerm setSourceNode(PlacementLocation sourceNode) {
    this.sourceNode = sourceNode;
    return this;
  }

  @Override
  public CapacityConstraintConstraintTerm set(String fieldName, Object value) {
    return (CapacityConstraintConstraintTerm) super.set(fieldName, value);
  }

  @Override
  public CapacityConstraintConstraintTerm clone() {
    return (CapacityConstraintConstraintTerm) super.clone();
  }

}
