/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Specifies the custom error response policy that must be applied when the backend service or
 * backend bucket responds with an error.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CustomErrorResponsePolicy extends com.google.api.client.json.GenericJson {

  /**
   * Specifies rules for returning error responses. In a given policy, if you specify rules for both
   * a range of error codes as well as rules for specific error codes then rules with specific error
   * codes have a higher priority. For example, assume that you configure a rule for 401 (Un-
   * authorized) code, and another for all 4 series error codes (4XX). If the backend service
   * returns a 401, then the rule for 401 will be applied. However if the backend service returns a
   * 403, the rule for 4xx takes effect.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<CustomErrorResponsePolicyCustomErrorResponseRule> errorResponseRules;

  /**
   * The full or partial URL to the BackendBucket resource that contains the custom error content.
   * Examples are: -
   * https://www.googleapis.com/compute/v1/projects/project/global/backendBuckets/myBackendBucket -
   * compute/v1/projects/project/global/backendBuckets/myBackendBucket -
   * global/backendBuckets/myBackendBucket If errorService is not specified at lower levels like
   * pathMatcher, pathRule and routeRule, an errorService specified at a higher level in the UrlMap
   * will be used. If UrlMap.defaultCustomErrorResponsePolicy contains one or more
   * errorResponseRules[], it must specify errorService. If load balancer cannot reach the
   * backendBucket, a simple Not Found Error will be returned, with the original response code (or
   * overrideResponseCode if configured). errorService is not supported for internal or regional
   * HTTP/HTTPS load balancers.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String errorService;

  /**
   * Specifies rules for returning error responses. In a given policy, if you specify rules for both
   * a range of error codes as well as rules for specific error codes then rules with specific error
   * codes have a higher priority. For example, assume that you configure a rule for 401 (Un-
   * authorized) code, and another for all 4 series error codes (4XX). If the backend service
   * returns a 401, then the rule for 401 will be applied. However if the backend service returns a
   * 403, the rule for 4xx takes effect.
   * @return value or {@code null} for none
   */
  public java.util.List<CustomErrorResponsePolicyCustomErrorResponseRule> getErrorResponseRules() {
    return errorResponseRules;
  }

  /**
   * Specifies rules for returning error responses. In a given policy, if you specify rules for both
   * a range of error codes as well as rules for specific error codes then rules with specific error
   * codes have a higher priority. For example, assume that you configure a rule for 401 (Un-
   * authorized) code, and another for all 4 series error codes (4XX). If the backend service
   * returns a 401, then the rule for 401 will be applied. However if the backend service returns a
   * 403, the rule for 4xx takes effect.
   * @param errorResponseRules errorResponseRules or {@code null} for none
   */
  public CustomErrorResponsePolicy setErrorResponseRules(java.util.List<CustomErrorResponsePolicyCustomErrorResponseRule> errorResponseRules) {
    this.errorResponseRules = errorResponseRules;
    return this;
  }

  /**
   * The full or partial URL to the BackendBucket resource that contains the custom error content.
   * Examples are: -
   * https://www.googleapis.com/compute/v1/projects/project/global/backendBuckets/myBackendBucket -
   * compute/v1/projects/project/global/backendBuckets/myBackendBucket -
   * global/backendBuckets/myBackendBucket If errorService is not specified at lower levels like
   * pathMatcher, pathRule and routeRule, an errorService specified at a higher level in the UrlMap
   * will be used. If UrlMap.defaultCustomErrorResponsePolicy contains one or more
   * errorResponseRules[], it must specify errorService. If load balancer cannot reach the
   * backendBucket, a simple Not Found Error will be returned, with the original response code (or
   * overrideResponseCode if configured). errorService is not supported for internal or regional
   * HTTP/HTTPS load balancers.
   * @return value or {@code null} for none
   */
  public java.lang.String getErrorService() {
    return errorService;
  }

  /**
   * The full or partial URL to the BackendBucket resource that contains the custom error content.
   * Examples are: -
   * https://www.googleapis.com/compute/v1/projects/project/global/backendBuckets/myBackendBucket -
   * compute/v1/projects/project/global/backendBuckets/myBackendBucket -
   * global/backendBuckets/myBackendBucket If errorService is not specified at lower levels like
   * pathMatcher, pathRule and routeRule, an errorService specified at a higher level in the UrlMap
   * will be used. If UrlMap.defaultCustomErrorResponsePolicy contains one or more
   * errorResponseRules[], it must specify errorService. If load balancer cannot reach the
   * backendBucket, a simple Not Found Error will be returned, with the original response code (or
   * overrideResponseCode if configured). errorService is not supported for internal or regional
   * HTTP/HTTPS load balancers.
   * @param errorService errorService or {@code null} for none
   */
  public CustomErrorResponsePolicy setErrorService(java.lang.String errorService) {
    this.errorService = errorService;
    return this;
  }

  @Override
  public CustomErrorResponsePolicy set(String fieldName, Object value) {
    return (CustomErrorResponsePolicy) super.set(fieldName, value);
  }

  @Override
  public CustomErrorResponsePolicy clone() {
    return (CustomErrorResponsePolicy) super.clone();
  }

}
