/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * [Output Only] Contains output only fields.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class StoragePoolResourceStatus extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] Sum of all the disks' provisioned IOPS.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long aggregateDiskProvisionedIops;

  /**
   * [Output Only] Sum of all the capacity provisioned in disks in this storage pool. A disk's
   * provisioned capacity is the same as its total capacity.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long aggregateDiskSizeGb;

  /**
   * [Output Only] Timestamp of the last successful resize in RFC3339 text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String lastResizeTimestamp;

  /**
   * [Output Only] Maximum allowed aggregate disk size in gigabytes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long maxAggregateDiskSizeGb;

  /**
   * [Output Only] Number of disks used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long numberOfDisks;

  /**
   * [Output Only] Space used by data stored in disks within the storage pool (in bytes).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long usedBytes;

  /**
   * [Output Only] Space used by compressed and deduped data stored in disks within the storage pool
   * (in bytes).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long usedReducedBytes;

  /**
   * [Output Only] Sum of all the disks' provisioned throughput in MB/s.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long usedThroughput;

  /**
   * [Output Only] Sum of all the disks' provisioned IOPS.
   * @return value or {@code null} for none
   */
  public java.lang.Long getAggregateDiskProvisionedIops() {
    return aggregateDiskProvisionedIops;
  }

  /**
   * [Output Only] Sum of all the disks' provisioned IOPS.
   * @param aggregateDiskProvisionedIops aggregateDiskProvisionedIops or {@code null} for none
   */
  public StoragePoolResourceStatus setAggregateDiskProvisionedIops(java.lang.Long aggregateDiskProvisionedIops) {
    this.aggregateDiskProvisionedIops = aggregateDiskProvisionedIops;
    return this;
  }

  /**
   * [Output Only] Sum of all the capacity provisioned in disks in this storage pool. A disk's
   * provisioned capacity is the same as its total capacity.
   * @return value or {@code null} for none
   */
  public java.lang.Long getAggregateDiskSizeGb() {
    return aggregateDiskSizeGb;
  }

  /**
   * [Output Only] Sum of all the capacity provisioned in disks in this storage pool. A disk's
   * provisioned capacity is the same as its total capacity.
   * @param aggregateDiskSizeGb aggregateDiskSizeGb or {@code null} for none
   */
  public StoragePoolResourceStatus setAggregateDiskSizeGb(java.lang.Long aggregateDiskSizeGb) {
    this.aggregateDiskSizeGb = aggregateDiskSizeGb;
    return this;
  }

  /**
   * [Output Only] Timestamp of the last successful resize in RFC3339 text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getLastResizeTimestamp() {
    return lastResizeTimestamp;
  }

  /**
   * [Output Only] Timestamp of the last successful resize in RFC3339 text format.
   * @param lastResizeTimestamp lastResizeTimestamp or {@code null} for none
   */
  public StoragePoolResourceStatus setLastResizeTimestamp(java.lang.String lastResizeTimestamp) {
    this.lastResizeTimestamp = lastResizeTimestamp;
    return this;
  }

  /**
   * [Output Only] Maximum allowed aggregate disk size in gigabytes.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMaxAggregateDiskSizeGb() {
    return maxAggregateDiskSizeGb;
  }

  /**
   * [Output Only] Maximum allowed aggregate disk size in gigabytes.
   * @param maxAggregateDiskSizeGb maxAggregateDiskSizeGb or {@code null} for none
   */
  public StoragePoolResourceStatus setMaxAggregateDiskSizeGb(java.lang.Long maxAggregateDiskSizeGb) {
    this.maxAggregateDiskSizeGb = maxAggregateDiskSizeGb;
    return this;
  }

  /**
   * [Output Only] Number of disks used.
   * @return value or {@code null} for none
   */
  public java.lang.Long getNumberOfDisks() {
    return numberOfDisks;
  }

  /**
   * [Output Only] Number of disks used.
   * @param numberOfDisks numberOfDisks or {@code null} for none
   */
  public StoragePoolResourceStatus setNumberOfDisks(java.lang.Long numberOfDisks) {
    this.numberOfDisks = numberOfDisks;
    return this;
  }

  /**
   * [Output Only] Space used by data stored in disks within the storage pool (in bytes).
   * @return value or {@code null} for none
   */
  public java.lang.Long getUsedBytes() {
    return usedBytes;
  }

  /**
   * [Output Only] Space used by data stored in disks within the storage pool (in bytes).
   * @param usedBytes usedBytes or {@code null} for none
   */
  public StoragePoolResourceStatus setUsedBytes(java.lang.Long usedBytes) {
    this.usedBytes = usedBytes;
    return this;
  }

  /**
   * [Output Only] Space used by compressed and deduped data stored in disks within the storage pool
   * (in bytes).
   * @return value or {@code null} for none
   */
  public java.lang.Long getUsedReducedBytes() {
    return usedReducedBytes;
  }

  /**
   * [Output Only] Space used by compressed and deduped data stored in disks within the storage pool
   * (in bytes).
   * @param usedReducedBytes usedReducedBytes or {@code null} for none
   */
  public StoragePoolResourceStatus setUsedReducedBytes(java.lang.Long usedReducedBytes) {
    this.usedReducedBytes = usedReducedBytes;
    return this;
  }

  /**
   * [Output Only] Sum of all the disks' provisioned throughput in MB/s.
   * @return value or {@code null} for none
   */
  public java.lang.Long getUsedThroughput() {
    return usedThroughput;
  }

  /**
   * [Output Only] Sum of all the disks' provisioned throughput in MB/s.
   * @param usedThroughput usedThroughput or {@code null} for none
   */
  public StoragePoolResourceStatus setUsedThroughput(java.lang.Long usedThroughput) {
    this.usedThroughput = usedThroughput;
    return this;
  }

  @Override
  public StoragePoolResourceStatus set(String fieldName, Object value) {
    return (StoragePoolResourceStatus) super.set(fieldName, value);
  }

  @Override
  public StoragePoolResourceStatus clone() {
    return (StoragePoolResourceStatus) super.clone();
  }

}
