/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for PlacementLocation.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PlacementLocation extends com.google.api.client.json.GenericJson {

  /**
   * Aggregation block id of the placement group.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String aggregationBlockId;

  /**
   * Partial or full URL of the resource policy for the placement group.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String resourcePolicy;

  /**
   * Aggregation block id of the placement group.
   * @return value or {@code null} for none
   */
  public java.lang.String getAggregationBlockId() {
    return aggregationBlockId;
  }

  /**
   * Aggregation block id of the placement group.
   * @param aggregationBlockId aggregationBlockId or {@code null} for none
   */
  public PlacementLocation setAggregationBlockId(java.lang.String aggregationBlockId) {
    this.aggregationBlockId = aggregationBlockId;
    return this;
  }

  /**
   * Partial or full URL of the resource policy for the placement group.
   * @return value or {@code null} for none
   */
  public java.lang.String getResourcePolicy() {
    return resourcePolicy;
  }

  /**
   * Partial or full URL of the resource policy for the placement group.
   * @param resourcePolicy resourcePolicy or {@code null} for none
   */
  public PlacementLocation setResourcePolicy(java.lang.String resourcePolicy) {
    this.resourcePolicy = resourcePolicy;
    return this;
  }

  @Override
  public PlacementLocation set(String fieldName, Object value) {
    return (PlacementLocation) super.set(fieldName, value);
  }

  @Override
  public PlacementLocation clone() {
    return (PlacementLocation) super.clone();
  }

}
