/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for RbacPolicy.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RbacPolicy extends com.google.api.client.json.GenericJson {

  /**
   * Name of the RbacPolicy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The list of permissions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Permission> permissions;

  static {
    // hack to force ProGuard to consider Permission used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Permission.class);
  }

  /**
   * The list of principals.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Principal> principals;

  static {
    // hack to force ProGuard to consider Principal used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Principal.class);
  }

  /**
   * Name of the RbacPolicy.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the RbacPolicy.
   * @param name name or {@code null} for none
   */
  public RbacPolicy setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The list of permissions.
   * @return value or {@code null} for none
   */
  public java.util.List<Permission> getPermissions() {
    return permissions;
  }

  /**
   * The list of permissions.
   * @param permissions permissions or {@code null} for none
   */
  public RbacPolicy setPermissions(java.util.List<Permission> permissions) {
    this.permissions = permissions;
    return this;
  }

  /**
   * The list of principals.
   * @return value or {@code null} for none
   */
  public java.util.List<Principal> getPrincipals() {
    return principals;
  }

  /**
   * The list of principals.
   * @param principals principals or {@code null} for none
   */
  public RbacPolicy setPrincipals(java.util.List<Principal> principals) {
    this.principals = principals;
    return this;
  }

  @Override
  public RbacPolicy set(String fieldName, Object value) {
    return (RbacPolicy) super.set(fieldName, value);
  }

  @Override
  public RbacPolicy clone() {
    return (RbacPolicy) super.clone();
  }

}
