/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Use to configure this PSC connection in tunneling mode. In tunneling mode traffic from consumer
 * to producer will be encapsulated as it crosses the VPC boundary and traffic from producer to
 * consumer will be decapsulated in the same manner.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ServiceAttachmentTunnelingConfig extends com.google.api.client.json.GenericJson {

  /**
   * Specify the encapsulation protocol and what metadata to include in incoming encapsulated packet
   * headers.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String encapsulationProfile;

  /**
   * How this Service Attachment will treat traffic sent to the tunnel_ip, destined for the consumer
   * network.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String routingMode;

  /**
   * Specify the encapsulation protocol and what metadata to include in incoming encapsulated packet
   * headers.
   * @return value or {@code null} for none
   */
  public java.lang.String getEncapsulationProfile() {
    return encapsulationProfile;
  }

  /**
   * Specify the encapsulation protocol and what metadata to include in incoming encapsulated packet
   * headers.
   * @param encapsulationProfile encapsulationProfile or {@code null} for none
   */
  public ServiceAttachmentTunnelingConfig setEncapsulationProfile(java.lang.String encapsulationProfile) {
    this.encapsulationProfile = encapsulationProfile;
    return this;
  }

  /**
   * How this Service Attachment will treat traffic sent to the tunnel_ip, destined for the consumer
   * network.
   * @return value or {@code null} for none
   */
  public java.lang.String getRoutingMode() {
    return routingMode;
  }

  /**
   * How this Service Attachment will treat traffic sent to the tunnel_ip, destined for the consumer
   * network.
   * @param routingMode routingMode or {@code null} for none
   */
  public ServiceAttachmentTunnelingConfig setRoutingMode(java.lang.String routingMode) {
    this.routingMode = routingMode;
    return this;
  }

  @Override
  public ServiceAttachmentTunnelingConfig set(String fieldName, Object value) {
    return (ServiceAttachmentTunnelingConfig) super.set(fieldName, value);
  }

  @Override
  public ServiceAttachmentTunnelingConfig clone() {
    return (ServiceAttachmentTunnelingConfig) super.clone();
  }

}
