/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Network Layer Reachability Information (NLRI) for a route.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BgpRouteNetworkLayerReachabilityInformation extends com.google.api.client.json.GenericJson {

  /**
   * Human readable CIDR notation for a prefix. E.g. 10.42.0.0/16. Deprecated in favor of prefix.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String destination;

  /**
   * If the BGP session supports multiple paths (RFC 7911), the path identifier for this route.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long pathId;

  /**
   * Human readable CIDR notation for a prefix. E.g. 10.42.0.0/16.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String prefix;

  /**
   * Human readable CIDR notation for a prefix. E.g. 10.42.0.0/16. Deprecated in favor of prefix.
   * @return value or {@code null} for none
   */
  public java.lang.String getDestination() {
    return destination;
  }

  /**
   * Human readable CIDR notation for a prefix. E.g. 10.42.0.0/16. Deprecated in favor of prefix.
   * @param destination destination or {@code null} for none
   */
  public BgpRouteNetworkLayerReachabilityInformation setDestination(java.lang.String destination) {
    this.destination = destination;
    return this;
  }

  /**
   * If the BGP session supports multiple paths (RFC 7911), the path identifier for this route.
   * @return value or {@code null} for none
   */
  public java.lang.Long getPathId() {
    return pathId;
  }

  /**
   * If the BGP session supports multiple paths (RFC 7911), the path identifier for this route.
   * @param pathId pathId or {@code null} for none
   */
  public BgpRouteNetworkLayerReachabilityInformation setPathId(java.lang.Long pathId) {
    this.pathId = pathId;
    return this;
  }

  /**
   * Human readable CIDR notation for a prefix. E.g. 10.42.0.0/16.
   * @return value or {@code null} for none
   */
  public java.lang.String getPrefix() {
    return prefix;
  }

  /**
   * Human readable CIDR notation for a prefix. E.g. 10.42.0.0/16.
   * @param prefix prefix or {@code null} for none
   */
  public BgpRouteNetworkLayerReachabilityInformation setPrefix(java.lang.String prefix) {
    this.prefix = prefix;
    return this;
  }

  @Override
  public BgpRouteNetworkLayerReachabilityInformation set(String fieldName, Object value) {
    return (BgpRouteNetworkLayerReachabilityInformation) super.set(fieldName, value);
  }

  @Override
  public BgpRouteNetworkLayerReachabilityInformation clone() {
    return (BgpRouteNetworkLayerReachabilityInformation) super.clone();
  }

}
