/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for DiskSettings.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DiskSettings extends com.google.api.client.json.GenericJson {

  /**
   * An optional parameter for storing the default resource policies that will be used for the Disks
   * created in the given scope. The Key is a string type, provided by customers to uniquely
   * identify the default Resource Policy entry. The Value is a Default ResourcePolicyDetails Object
   * used to represent the detailed information of the Resource Policy entry.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, DiskSettingsResourcePolicyDetails> defaultResourcePolicies;

  /**
   * An optional parameter for storing the default resource policies that will be used for the Disks
   * created in the given scope. The Key is a string type, provided by customers to uniquely
   * identify the default Resource Policy entry. The Value is a Default ResourcePolicyDetails Object
   * used to represent the detailed information of the Resource Policy entry.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, DiskSettingsResourcePolicyDetails> getDefaultResourcePolicies() {
    return defaultResourcePolicies;
  }

  /**
   * An optional parameter for storing the default resource policies that will be used for the Disks
   * created in the given scope. The Key is a string type, provided by customers to uniquely
   * identify the default Resource Policy entry. The Value is a Default ResourcePolicyDetails Object
   * used to represent the detailed information of the Resource Policy entry.
   * @param defaultResourcePolicies defaultResourcePolicies or {@code null} for none
   */
  public DiskSettings setDefaultResourcePolicies(java.util.Map<String, DiskSettingsResourcePolicyDetails> defaultResourcePolicies) {
    this.defaultResourcePolicies = defaultResourcePolicies;
    return this;
  }

  @Override
  public DiskSettings set(String fieldName, Object value) {
    return (DiskSettings) super.set(fieldName, value);
  }

  @Override
  public DiskSettings clone() {
    return (DiskSettings) super.clone();
  }

}
