/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Configuration information for enabling Application Aware Interconnect (AAI) on this Cloud
 * Interconnect connection between Google and your on-premises router.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InterconnectApplicationAwareInterconnect extends com.google.api.client.json.GenericJson {

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InterconnectApplicationAwareInterconnectBandwidthPercentagePolicy bandwidthPercentagePolicy;

  /**
   * A description for the AAI profile on this interconnect.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String profileDescription;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InterconnectApplicationAwareInterconnectStrictPriorityPolicy strictPriorityPolicy;

  /**
   * @return value or {@code null} for none
   */
  public InterconnectApplicationAwareInterconnectBandwidthPercentagePolicy getBandwidthPercentagePolicy() {
    return bandwidthPercentagePolicy;
  }

  /**
   * @param bandwidthPercentagePolicy bandwidthPercentagePolicy or {@code null} for none
   */
  public InterconnectApplicationAwareInterconnect setBandwidthPercentagePolicy(InterconnectApplicationAwareInterconnectBandwidthPercentagePolicy bandwidthPercentagePolicy) {
    this.bandwidthPercentagePolicy = bandwidthPercentagePolicy;
    return this;
  }

  /**
   * A description for the AAI profile on this interconnect.
   * @return value or {@code null} for none
   */
  public java.lang.String getProfileDescription() {
    return profileDescription;
  }

  /**
   * A description for the AAI profile on this interconnect.
   * @param profileDescription profileDescription or {@code null} for none
   */
  public InterconnectApplicationAwareInterconnect setProfileDescription(java.lang.String profileDescription) {
    this.profileDescription = profileDescription;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public InterconnectApplicationAwareInterconnectStrictPriorityPolicy getStrictPriorityPolicy() {
    return strictPriorityPolicy;
  }

  /**
   * @param strictPriorityPolicy strictPriorityPolicy or {@code null} for none
   */
  public InterconnectApplicationAwareInterconnect setStrictPriorityPolicy(InterconnectApplicationAwareInterconnectStrictPriorityPolicy strictPriorityPolicy) {
    this.strictPriorityPolicy = strictPriorityPolicy;
    return this;
  }

  @Override
  public InterconnectApplicationAwareInterconnect set(String fieldName, Object value) {
    return (InterconnectApplicationAwareInterconnect) super.set(fieldName, value);
  }

  @Override
  public InterconnectApplicationAwareInterconnect clone() {
    return (InterconnectApplicationAwareInterconnect) super.clone();
  }

}
