/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for NamedSet.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class NamedSet extends com.google.api.client.json.GenericJson {

  /**
   * CEL expressions that are comparable to constructs of this set's type (see Policy Language).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Expr> elements;

  static {
    // hack to force ProGuard to consider Expr used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Expr.class);
  }

  /**
   * A fingerprint for the Named Set being applied to this Router, which is essentially a hash of
   * the Named Set used for optimistic locking. The fingerprint is initially generated by Compute
   * Engine and changes after every request to modify or update the Named Set. You must always
   * provide an up-to-date fingerprint hash in order to update or change labels. To see the latest
   * fingerprint, make a getNamedSet() request to retrieve a Named Set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fingerprint;

  /**
   * This set's name, which must be a resource ID segment and unique within all named sets owned by
   * the Router. Name should conform to RFC1035.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * This named set's type
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * CEL expressions that are comparable to constructs of this set's type (see Policy Language).
   * @return value or {@code null} for none
   */
  public java.util.List<Expr> getElements() {
    return elements;
  }

  /**
   * CEL expressions that are comparable to constructs of this set's type (see Policy Language).
   * @param elements elements or {@code null} for none
   */
  public NamedSet setElements(java.util.List<Expr> elements) {
    this.elements = elements;
    return this;
  }

  /**
   * A fingerprint for the Named Set being applied to this Router, which is essentially a hash of
   * the Named Set used for optimistic locking. The fingerprint is initially generated by Compute
   * Engine and changes after every request to modify or update the Named Set. You must always
   * provide an up-to-date fingerprint hash in order to update or change labels. To see the latest
   * fingerprint, make a getNamedSet() request to retrieve a Named Set.
   * @see #decodeFingerprint()
   * @return value or {@code null} for none
   */
  public java.lang.String getFingerprint() {
    return fingerprint;
  }

  /**
   * A fingerprint for the Named Set being applied to this Router, which is essentially a hash of
   * the Named Set used for optimistic locking. The fingerprint is initially generated by Compute
   * Engine and changes after every request to modify or update the Named Set. You must always
   * provide an up-to-date fingerprint hash in order to update or change labels. To see the latest
   * fingerprint, make a getNamedSet() request to retrieve a Named Set.
   * @see #getFingerprint()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeFingerprint() {
    return com.google.api.client.util.Base64.decodeBase64(fingerprint);
  }

  /**
   * A fingerprint for the Named Set being applied to this Router, which is essentially a hash of
   * the Named Set used for optimistic locking. The fingerprint is initially generated by Compute
   * Engine and changes after every request to modify or update the Named Set. You must always
   * provide an up-to-date fingerprint hash in order to update or change labels. To see the latest
   * fingerprint, make a getNamedSet() request to retrieve a Named Set.
   * @see #encodeFingerprint()
   * @param fingerprint fingerprint or {@code null} for none
   */
  public NamedSet setFingerprint(java.lang.String fingerprint) {
    this.fingerprint = fingerprint;
    return this;
  }

  /**
   * A fingerprint for the Named Set being applied to this Router, which is essentially a hash of
   * the Named Set used for optimistic locking. The fingerprint is initially generated by Compute
   * Engine and changes after every request to modify or update the Named Set. You must always
   * provide an up-to-date fingerprint hash in order to update or change labels. To see the latest
   * fingerprint, make a getNamedSet() request to retrieve a Named Set.
   * @see #setFingerprint()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public NamedSet encodeFingerprint(byte[] fingerprint) {
    this.fingerprint = com.google.api.client.util.Base64.encodeBase64URLSafeString(fingerprint);
    return this;
  }

  /**
   * This set's name, which must be a resource ID segment and unique within all named sets owned by
   * the Router. Name should conform to RFC1035.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * This set's name, which must be a resource ID segment and unique within all named sets owned by
   * the Router. Name should conform to RFC1035.
   * @param name name or {@code null} for none
   */
  public NamedSet setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * This named set's type
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * This named set's type
   * @param type type or {@code null} for none
   */
  public NamedSet setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public NamedSet set(String fieldName, Object value) {
    return (NamedSet) super.set(fieldName, value);
  }

  @Override
  public NamedSet clone() {
    return (NamedSet) super.clone();
  }

}
