/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for InstanceGroupManagerStandbyPolicy.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InstanceGroupManagerStandbyPolicy extends com.google.api.client.json.GenericJson {

  /**
   * Specifies the number of seconds that the MIG should wait to suspend or stop a VM after that VM
   * was created. The initial delay gives the initialization script the time to prepare your VM for
   * a quick scale out. The value of initial delay must be between 0 and 3600 seconds. The default
   * value is 0.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer initialDelaySec;

  /**
   * Defines how a MIG resumes or starts VMs from a standby pool when the group scales out. The
   * default mode is `MANUAL`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mode;

  /**
   * Specifies the number of seconds that the MIG should wait to suspend or stop a VM after that VM
   * was created. The initial delay gives the initialization script the time to prepare your VM for
   * a quick scale out. The value of initial delay must be between 0 and 3600 seconds. The default
   * value is 0.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getInitialDelaySec() {
    return initialDelaySec;
  }

  /**
   * Specifies the number of seconds that the MIG should wait to suspend or stop a VM after that VM
   * was created. The initial delay gives the initialization script the time to prepare your VM for
   * a quick scale out. The value of initial delay must be between 0 and 3600 seconds. The default
   * value is 0.
   * @param initialDelaySec initialDelaySec or {@code null} for none
   */
  public InstanceGroupManagerStandbyPolicy setInitialDelaySec(java.lang.Integer initialDelaySec) {
    this.initialDelaySec = initialDelaySec;
    return this;
  }

  /**
   * Defines how a MIG resumes or starts VMs from a standby pool when the group scales out. The
   * default mode is `MANUAL`.
   * @return value or {@code null} for none
   */
  public java.lang.String getMode() {
    return mode;
  }

  /**
   * Defines how a MIG resumes or starts VMs from a standby pool when the group scales out. The
   * default mode is `MANUAL`.
   * @param mode mode or {@code null} for none
   */
  public InstanceGroupManagerStandbyPolicy setMode(java.lang.String mode) {
    this.mode = mode;
    return this;
  }

  @Override
  public InstanceGroupManagerStandbyPolicy set(String fieldName, Object value) {
    return (InstanceGroupManagerStandbyPolicy) super.set(fieldName, value);
  }

  @Override
  public InstanceGroupManagerStandbyPolicy clone() {
    return (InstanceGroupManagerStandbyPolicy) super.clone();
  }

}
