/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for NetworkPlacementNetworkFeatures.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class NetworkPlacementNetworkFeatures extends com.google.api.client.json.GenericJson {

  /**
   * Specifies whether auto mode subnet creation is allowed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String allowAutoModeSubnet;

  /**
   * Specifies whether cloud NAT creation is allowed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String allowCloudNat;

  /**
   * Specifies whether cloud router creation is allowed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String allowCloudRouter;

  /**
   * Specifies whether Cloud Interconnect creation is allowed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String allowInterconnect;

  /**
   * Specifies whether cloud load balancing is allowed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String allowLoadBalancing;

  /**
   * Specifies whether multi-nic in the same network is allowed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String allowMultiNicInSameNetwork;

  /**
   * Specifies whether Packet Mirroring 1.0 is supported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String allowPacketMirroring;

  /**
   * Specifies whether private Google access is allowed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String allowPrivateGoogleAccess;

  /**
   * Specifies whether PSC creation is allowed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String allowPsc;

  /**
   * Specifies whether unicast within the same network is allowed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String allowSameNetworkUnicast;

  /**
   * Specifies whether static route creation is allowed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String allowStaticRoutes;

  /**
   * Specifies whether VPC peering is allowed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String allowVpcPeering;

  /**
   * Specifies whether VPN creation is allowed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String allowVpn;

  /**
   * Specifies which subnetwork purposes are supported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> allowedSubnetPurposes;

  /**
   * Specifies which subnetwork stack types are supported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> allowedSubnetStackTypes;

  /**
   * If set, limits the interface types that the network supports. If empty, all interface types are
   * supported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> interfaceTypes;

  /**
   * Specifies which type of multicast is supported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String multicast;

  /**
   * Specifies which type of unicast is supported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String unicast;

  /**
   * Specifies whether auto mode subnet creation is allowed.
   * @return value or {@code null} for none
   */
  public java.lang.String getAllowAutoModeSubnet() {
    return allowAutoModeSubnet;
  }

  /**
   * Specifies whether auto mode subnet creation is allowed.
   * @param allowAutoModeSubnet allowAutoModeSubnet or {@code null} for none
   */
  public NetworkPlacementNetworkFeatures setAllowAutoModeSubnet(java.lang.String allowAutoModeSubnet) {
    this.allowAutoModeSubnet = allowAutoModeSubnet;
    return this;
  }

  /**
   * Specifies whether cloud NAT creation is allowed.
   * @return value or {@code null} for none
   */
  public java.lang.String getAllowCloudNat() {
    return allowCloudNat;
  }

  /**
   * Specifies whether cloud NAT creation is allowed.
   * @param allowCloudNat allowCloudNat or {@code null} for none
   */
  public NetworkPlacementNetworkFeatures setAllowCloudNat(java.lang.String allowCloudNat) {
    this.allowCloudNat = allowCloudNat;
    return this;
  }

  /**
   * Specifies whether cloud router creation is allowed.
   * @return value or {@code null} for none
   */
  public java.lang.String getAllowCloudRouter() {
    return allowCloudRouter;
  }

  /**
   * Specifies whether cloud router creation is allowed.
   * @param allowCloudRouter allowCloudRouter or {@code null} for none
   */
  public NetworkPlacementNetworkFeatures setAllowCloudRouter(java.lang.String allowCloudRouter) {
    this.allowCloudRouter = allowCloudRouter;
    return this;
  }

  /**
   * Specifies whether Cloud Interconnect creation is allowed.
   * @return value or {@code null} for none
   */
  public java.lang.String getAllowInterconnect() {
    return allowInterconnect;
  }

  /**
   * Specifies whether Cloud Interconnect creation is allowed.
   * @param allowInterconnect allowInterconnect or {@code null} for none
   */
  public NetworkPlacementNetworkFeatures setAllowInterconnect(java.lang.String allowInterconnect) {
    this.allowInterconnect = allowInterconnect;
    return this;
  }

  /**
   * Specifies whether cloud load balancing is allowed.
   * @return value or {@code null} for none
   */
  public java.lang.String getAllowLoadBalancing() {
    return allowLoadBalancing;
  }

  /**
   * Specifies whether cloud load balancing is allowed.
   * @param allowLoadBalancing allowLoadBalancing or {@code null} for none
   */
  public NetworkPlacementNetworkFeatures setAllowLoadBalancing(java.lang.String allowLoadBalancing) {
    this.allowLoadBalancing = allowLoadBalancing;
    return this;
  }

  /**
   * Specifies whether multi-nic in the same network is allowed.
   * @return value or {@code null} for none
   */
  public java.lang.String getAllowMultiNicInSameNetwork() {
    return allowMultiNicInSameNetwork;
  }

  /**
   * Specifies whether multi-nic in the same network is allowed.
   * @param allowMultiNicInSameNetwork allowMultiNicInSameNetwork or {@code null} for none
   */
  public NetworkPlacementNetworkFeatures setAllowMultiNicInSameNetwork(java.lang.String allowMultiNicInSameNetwork) {
    this.allowMultiNicInSameNetwork = allowMultiNicInSameNetwork;
    return this;
  }

  /**
   * Specifies whether Packet Mirroring 1.0 is supported.
   * @return value or {@code null} for none
   */
  public java.lang.String getAllowPacketMirroring() {
    return allowPacketMirroring;
  }

  /**
   * Specifies whether Packet Mirroring 1.0 is supported.
   * @param allowPacketMirroring allowPacketMirroring or {@code null} for none
   */
  public NetworkPlacementNetworkFeatures setAllowPacketMirroring(java.lang.String allowPacketMirroring) {
    this.allowPacketMirroring = allowPacketMirroring;
    return this;
  }

  /**
   * Specifies whether private Google access is allowed.
   * @return value or {@code null} for none
   */
  public java.lang.String getAllowPrivateGoogleAccess() {
    return allowPrivateGoogleAccess;
  }

  /**
   * Specifies whether private Google access is allowed.
   * @param allowPrivateGoogleAccess allowPrivateGoogleAccess or {@code null} for none
   */
  public NetworkPlacementNetworkFeatures setAllowPrivateGoogleAccess(java.lang.String allowPrivateGoogleAccess) {
    this.allowPrivateGoogleAccess = allowPrivateGoogleAccess;
    return this;
  }

  /**
   * Specifies whether PSC creation is allowed.
   * @return value or {@code null} for none
   */
  public java.lang.String getAllowPsc() {
    return allowPsc;
  }

  /**
   * Specifies whether PSC creation is allowed.
   * @param allowPsc allowPsc or {@code null} for none
   */
  public NetworkPlacementNetworkFeatures setAllowPsc(java.lang.String allowPsc) {
    this.allowPsc = allowPsc;
    return this;
  }

  /**
   * Specifies whether unicast within the same network is allowed.
   * @return value or {@code null} for none
   */
  public java.lang.String getAllowSameNetworkUnicast() {
    return allowSameNetworkUnicast;
  }

  /**
   * Specifies whether unicast within the same network is allowed.
   * @param allowSameNetworkUnicast allowSameNetworkUnicast or {@code null} for none
   */
  public NetworkPlacementNetworkFeatures setAllowSameNetworkUnicast(java.lang.String allowSameNetworkUnicast) {
    this.allowSameNetworkUnicast = allowSameNetworkUnicast;
    return this;
  }

  /**
   * Specifies whether static route creation is allowed.
   * @return value or {@code null} for none
   */
  public java.lang.String getAllowStaticRoutes() {
    return allowStaticRoutes;
  }

  /**
   * Specifies whether static route creation is allowed.
   * @param allowStaticRoutes allowStaticRoutes or {@code null} for none
   */
  public NetworkPlacementNetworkFeatures setAllowStaticRoutes(java.lang.String allowStaticRoutes) {
    this.allowStaticRoutes = allowStaticRoutes;
    return this;
  }

  /**
   * Specifies whether VPC peering is allowed.
   * @return value or {@code null} for none
   */
  public java.lang.String getAllowVpcPeering() {
    return allowVpcPeering;
  }

  /**
   * Specifies whether VPC peering is allowed.
   * @param allowVpcPeering allowVpcPeering or {@code null} for none
   */
  public NetworkPlacementNetworkFeatures setAllowVpcPeering(java.lang.String allowVpcPeering) {
    this.allowVpcPeering = allowVpcPeering;
    return this;
  }

  /**
   * Specifies whether VPN creation is allowed.
   * @return value or {@code null} for none
   */
  public java.lang.String getAllowVpn() {
    return allowVpn;
  }

  /**
   * Specifies whether VPN creation is allowed.
   * @param allowVpn allowVpn or {@code null} for none
   */
  public NetworkPlacementNetworkFeatures setAllowVpn(java.lang.String allowVpn) {
    this.allowVpn = allowVpn;
    return this;
  }

  /**
   * Specifies which subnetwork purposes are supported.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getAllowedSubnetPurposes() {
    return allowedSubnetPurposes;
  }

  /**
   * Specifies which subnetwork purposes are supported.
   * @param allowedSubnetPurposes allowedSubnetPurposes or {@code null} for none
   */
  public NetworkPlacementNetworkFeatures setAllowedSubnetPurposes(java.util.List<java.lang.String> allowedSubnetPurposes) {
    this.allowedSubnetPurposes = allowedSubnetPurposes;
    return this;
  }

  /**
   * Specifies which subnetwork stack types are supported.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getAllowedSubnetStackTypes() {
    return allowedSubnetStackTypes;
  }

  /**
   * Specifies which subnetwork stack types are supported.
   * @param allowedSubnetStackTypes allowedSubnetStackTypes or {@code null} for none
   */
  public NetworkPlacementNetworkFeatures setAllowedSubnetStackTypes(java.util.List<java.lang.String> allowedSubnetStackTypes) {
    this.allowedSubnetStackTypes = allowedSubnetStackTypes;
    return this;
  }

  /**
   * If set, limits the interface types that the network supports. If empty, all interface types are
   * supported.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getInterfaceTypes() {
    return interfaceTypes;
  }

  /**
   * If set, limits the interface types that the network supports. If empty, all interface types are
   * supported.
   * @param interfaceTypes interfaceTypes or {@code null} for none
   */
  public NetworkPlacementNetworkFeatures setInterfaceTypes(java.util.List<java.lang.String> interfaceTypes) {
    this.interfaceTypes = interfaceTypes;
    return this;
  }

  /**
   * Specifies which type of multicast is supported.
   * @return value or {@code null} for none
   */
  public java.lang.String getMulticast() {
    return multicast;
  }

  /**
   * Specifies which type of multicast is supported.
   * @param multicast multicast or {@code null} for none
   */
  public NetworkPlacementNetworkFeatures setMulticast(java.lang.String multicast) {
    this.multicast = multicast;
    return this;
  }

  /**
   * Specifies which type of unicast is supported.
   * @return value or {@code null} for none
   */
  public java.lang.String getUnicast() {
    return unicast;
  }

  /**
   * Specifies which type of unicast is supported.
   * @param unicast unicast or {@code null} for none
   */
  public NetworkPlacementNetworkFeatures setUnicast(java.lang.String unicast) {
    this.unicast = unicast;
    return this;
  }

  @Override
  public NetworkPlacementNetworkFeatures set(String fieldName, Object value) {
    return (NetworkPlacementNetworkFeatures) super.set(fieldName, value);
  }

  @Override
  public NetworkPlacementNetworkFeatures clone() {
    return (NetworkPlacementNetworkFeatures) super.clone();
  }

}
