/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Configuration for gracefully shutting down the instance.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SchedulingGracefulShutdown extends com.google.api.client.json.GenericJson {

  /**
   * Opts-in for graceful shutdown.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean enabled;

  /**
   * Specifies time needed to gracefully shut down the instance. After that time, the instance goes
   * to STOPPING even if graceful shutdown is not completed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Duration maxDuration;

  /**
   * Opts-in for graceful shutdown.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEnabled() {
    return enabled;
  }

  /**
   * Opts-in for graceful shutdown.
   * @param enabled enabled or {@code null} for none
   */
  public SchedulingGracefulShutdown setEnabled(java.lang.Boolean enabled) {
    this.enabled = enabled;
    return this;
  }

  /**
   * Specifies time needed to gracefully shut down the instance. After that time, the instance goes
   * to STOPPING even if graceful shutdown is not completed.
   * @return value or {@code null} for none
   */
  public Duration getMaxDuration() {
    return maxDuration;
  }

  /**
   * Specifies time needed to gracefully shut down the instance. After that time, the instance goes
   * to STOPPING even if graceful shutdown is not completed.
   * @param maxDuration maxDuration or {@code null} for none
   */
  public SchedulingGracefulShutdown setMaxDuration(Duration maxDuration) {
    this.maxDuration = maxDuration;
    return this;
  }

  @Override
  public SchedulingGracefulShutdown set(String fieldName, Object value) {
    return (SchedulingGracefulShutdown) super.set(fieldName, value);
  }

  @Override
  public SchedulingGracefulShutdown clone() {
    return (SchedulingGracefulShutdown) super.clone();
  }

}
