/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Configurations to specifc granular traffic units processed by Adaptive Protection.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfigTrafficGranularityConfig extends com.google.api.client.json.GenericJson {

  /**
   * If enabled, traffic matching each unique value for the specified type constitutes a separate
   * traffic unit. It can only be set to true if `value` is empty.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean enableEachUniqueValue;

  /**
   * Type of this configuration.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Requests that match this value constitute a granular traffic unit.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String value;

  /**
   * If enabled, traffic matching each unique value for the specified type constitutes a separate
   * traffic unit. It can only be set to true if `value` is empty.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEnableEachUniqueValue() {
    return enableEachUniqueValue;
  }

  /**
   * If enabled, traffic matching each unique value for the specified type constitutes a separate
   * traffic unit. It can only be set to true if `value` is empty.
   * @param enableEachUniqueValue enableEachUniqueValue or {@code null} for none
   */
  public SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfigTrafficGranularityConfig setEnableEachUniqueValue(java.lang.Boolean enableEachUniqueValue) {
    this.enableEachUniqueValue = enableEachUniqueValue;
    return this;
  }

  /**
   * Type of this configuration.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Type of this configuration.
   * @param type type or {@code null} for none
   */
  public SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfigTrafficGranularityConfig setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  /**
   * Requests that match this value constitute a granular traffic unit.
   * @return value or {@code null} for none
   */
  public java.lang.String getValue() {
    return value;
  }

  /**
   * Requests that match this value constitute a granular traffic unit.
   * @param value value or {@code null} for none
   */
  public SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfigTrafficGranularityConfig setValue(java.lang.String value) {
    this.value = value;
    return this;
  }

  @Override
  public SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfigTrafficGranularityConfig set(String fieldName, Object value) {
    return (SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfigTrafficGranularityConfig) super.set(fieldName, value);
  }

  @Override
  public SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfigTrafficGranularityConfig clone() {
    return (SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfigTrafficGranularityConfig) super.clone();
  }

}
