/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * A GroupPlacementPolicy specifies resource placement configuration. It specifies the failure
 * bucket separation
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ResourcePolicyGroupPlacementPolicy extends com.google.api.client.json.GenericJson {

  /**
   * The number of availability domains to spread instances across. If two instances are in
   * different availability domain, they are not in the same low latency network.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer availabilityDomainCount;

  /**
   * Specifies network collocation
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String collocation;

  /**
   * Specifies the number of max logical switches.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer maxDistance;

  /**
   * Scope specifies the availability domain to which the VMs should be spread.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String scope;

  /**
   * Specifies the number of slices in a multislice workload.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer sliceCount;

  /**
   * Specifies the shape of the TPU slice
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String tpuTopology;

  /**
   * Number of VMs in this placement group. Google does not recommend that you use this field unless
   * you use a compact policy and you want your policy to work only if it contains this exact number
   * of VMs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer vmCount;

  /**
   * The number of availability domains to spread instances across. If two instances are in
   * different availability domain, they are not in the same low latency network.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getAvailabilityDomainCount() {
    return availabilityDomainCount;
  }

  /**
   * The number of availability domains to spread instances across. If two instances are in
   * different availability domain, they are not in the same low latency network.
   * @param availabilityDomainCount availabilityDomainCount or {@code null} for none
   */
  public ResourcePolicyGroupPlacementPolicy setAvailabilityDomainCount(java.lang.Integer availabilityDomainCount) {
    this.availabilityDomainCount = availabilityDomainCount;
    return this;
  }

  /**
   * Specifies network collocation
   * @return value or {@code null} for none
   */
  public java.lang.String getCollocation() {
    return collocation;
  }

  /**
   * Specifies network collocation
   * @param collocation collocation or {@code null} for none
   */
  public ResourcePolicyGroupPlacementPolicy setCollocation(java.lang.String collocation) {
    this.collocation = collocation;
    return this;
  }

  /**
   * Specifies the number of max logical switches.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMaxDistance() {
    return maxDistance;
  }

  /**
   * Specifies the number of max logical switches.
   * @param maxDistance maxDistance or {@code null} for none
   */
  public ResourcePolicyGroupPlacementPolicy setMaxDistance(java.lang.Integer maxDistance) {
    this.maxDistance = maxDistance;
    return this;
  }

  /**
   * Scope specifies the availability domain to which the VMs should be spread.
   * @return value or {@code null} for none
   */
  public java.lang.String getScope() {
    return scope;
  }

  /**
   * Scope specifies the availability domain to which the VMs should be spread.
   * @param scope scope or {@code null} for none
   */
  public ResourcePolicyGroupPlacementPolicy setScope(java.lang.String scope) {
    this.scope = scope;
    return this;
  }

  /**
   * Specifies the number of slices in a multislice workload.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getSliceCount() {
    return sliceCount;
  }

  /**
   * Specifies the number of slices in a multislice workload.
   * @param sliceCount sliceCount or {@code null} for none
   */
  public ResourcePolicyGroupPlacementPolicy setSliceCount(java.lang.Integer sliceCount) {
    this.sliceCount = sliceCount;
    return this;
  }

  /**
   * Specifies the shape of the TPU slice
   * @return value or {@code null} for none
   */
  public java.lang.String getTpuTopology() {
    return tpuTopology;
  }

  /**
   * Specifies the shape of the TPU slice
   * @param tpuTopology tpuTopology or {@code null} for none
   */
  public ResourcePolicyGroupPlacementPolicy setTpuTopology(java.lang.String tpuTopology) {
    this.tpuTopology = tpuTopology;
    return this;
  }

  /**
   * Number of VMs in this placement group. Google does not recommend that you use this field unless
   * you use a compact policy and you want your policy to work only if it contains this exact number
   * of VMs.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getVmCount() {
    return vmCount;
  }

  /**
   * Number of VMs in this placement group. Google does not recommend that you use this field unless
   * you use a compact policy and you want your policy to work only if it contains this exact number
   * of VMs.
   * @param vmCount vmCount or {@code null} for none
   */
  public ResourcePolicyGroupPlacementPolicy setVmCount(java.lang.Integer vmCount) {
    this.vmCount = vmCount;
    return this;
  }

  @Override
  public ResourcePolicyGroupPlacementPolicy set(String fieldName, Object value) {
    return (ResourcePolicyGroupPlacementPolicy) super.set(fieldName, value);
  }

  @Override
  public ResourcePolicyGroupPlacementPolicy clone() {
    return (ResourcePolicyGroupPlacementPolicy) super.clone();
  }

}
