/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * The available logging options for the load balancer traffic served by this backend service.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BackendServiceLogConfig extends com.google.api.client.json.GenericJson {

  /**
   * Denotes whether to enable logging for the load balancer traffic served by this backend service.
   * The default value is false.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean enable;

  /**
   * Deprecated in favor of optionalMode. This field can only be specified if logging is enabled for
   * this backend service. Configures whether all, none or a subset of optional fields should be
   * added to the reported logs. One of [INCLUDE_ALL_OPTIONAL, EXCLUDE_ALL_OPTIONAL, CUSTOM].
   * Default is EXCLUDE_ALL_OPTIONAL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String optional;

  /**
   * This field can only be specified if logging is enabled for this backend service and
   * "logConfig.optionalMode" was set to CUSTOM. Contains a list of optional fields you want to
   * include in the logs. For example: serverInstance, serverGkeDetails.cluster,
   * serverGkeDetails.pod.podNamespace
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> optionalFields;

  /**
   * This field can only be specified if logging is enabled for this backend service. Configures
   * whether all, none or a subset of optional fields should be added to the reported logs. One of
   * [INCLUDE_ALL_OPTIONAL, EXCLUDE_ALL_OPTIONAL, CUSTOM]. Default is EXCLUDE_ALL_OPTIONAL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String optionalMode;

  /**
   * This field can only be specified if logging is enabled for this backend service. The value of
   * the field must be in [0, 1]. This configures the sampling rate of requests to the load balancer
   * where 1.0 means all logged requests are reported and 0.0 means no logged requests are reported.
   * The default value is 1.0.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float sampleRate;

  /**
   * Denotes whether to enable logging for the load balancer traffic served by this backend service.
   * The default value is false.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEnable() {
    return enable;
  }

  /**
   * Denotes whether to enable logging for the load balancer traffic served by this backend service.
   * The default value is false.
   * @param enable enable or {@code null} for none
   */
  public BackendServiceLogConfig setEnable(java.lang.Boolean enable) {
    this.enable = enable;
    return this;
  }

  /**
   * Deprecated in favor of optionalMode. This field can only be specified if logging is enabled for
   * this backend service. Configures whether all, none or a subset of optional fields should be
   * added to the reported logs. One of [INCLUDE_ALL_OPTIONAL, EXCLUDE_ALL_OPTIONAL, CUSTOM].
   * Default is EXCLUDE_ALL_OPTIONAL.
   * @return value or {@code null} for none
   */
  public java.lang.String getOptional() {
    return optional;
  }

  /**
   * Deprecated in favor of optionalMode. This field can only be specified if logging is enabled for
   * this backend service. Configures whether all, none or a subset of optional fields should be
   * added to the reported logs. One of [INCLUDE_ALL_OPTIONAL, EXCLUDE_ALL_OPTIONAL, CUSTOM].
   * Default is EXCLUDE_ALL_OPTIONAL.
   * @param optional optional or {@code null} for none
   */
  public BackendServiceLogConfig setOptional(java.lang.String optional) {
    this.optional = optional;
    return this;
  }

  /**
   * This field can only be specified if logging is enabled for this backend service and
   * "logConfig.optionalMode" was set to CUSTOM. Contains a list of optional fields you want to
   * include in the logs. For example: serverInstance, serverGkeDetails.cluster,
   * serverGkeDetails.pod.podNamespace
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getOptionalFields() {
    return optionalFields;
  }

  /**
   * This field can only be specified if logging is enabled for this backend service and
   * "logConfig.optionalMode" was set to CUSTOM. Contains a list of optional fields you want to
   * include in the logs. For example: serverInstance, serverGkeDetails.cluster,
   * serverGkeDetails.pod.podNamespace
   * @param optionalFields optionalFields or {@code null} for none
   */
  public BackendServiceLogConfig setOptionalFields(java.util.List<java.lang.String> optionalFields) {
    this.optionalFields = optionalFields;
    return this;
  }

  /**
   * This field can only be specified if logging is enabled for this backend service. Configures
   * whether all, none or a subset of optional fields should be added to the reported logs. One of
   * [INCLUDE_ALL_OPTIONAL, EXCLUDE_ALL_OPTIONAL, CUSTOM]. Default is EXCLUDE_ALL_OPTIONAL.
   * @return value or {@code null} for none
   */
  public java.lang.String getOptionalMode() {
    return optionalMode;
  }

  /**
   * This field can only be specified if logging is enabled for this backend service. Configures
   * whether all, none or a subset of optional fields should be added to the reported logs. One of
   * [INCLUDE_ALL_OPTIONAL, EXCLUDE_ALL_OPTIONAL, CUSTOM]. Default is EXCLUDE_ALL_OPTIONAL.
   * @param optionalMode optionalMode or {@code null} for none
   */
  public BackendServiceLogConfig setOptionalMode(java.lang.String optionalMode) {
    this.optionalMode = optionalMode;
    return this;
  }

  /**
   * This field can only be specified if logging is enabled for this backend service. The value of
   * the field must be in [0, 1]. This configures the sampling rate of requests to the load balancer
   * where 1.0 means all logged requests are reported and 0.0 means no logged requests are reported.
   * The default value is 1.0.
   * @return value or {@code null} for none
   */
  public java.lang.Float getSampleRate() {
    return sampleRate;
  }

  /**
   * This field can only be specified if logging is enabled for this backend service. The value of
   * the field must be in [0, 1]. This configures the sampling rate of requests to the load balancer
   * where 1.0 means all logged requests are reported and 0.0 means no logged requests are reported.
   * The default value is 1.0.
   * @param sampleRate sampleRate or {@code null} for none
   */
  public BackendServiceLogConfig setSampleRate(java.lang.Float sampleRate) {
    this.sampleRate = sampleRate;
    return this;
  }

  @Override
  public BackendServiceLogConfig set(String fieldName, Object value) {
    return (BackendServiceLogConfig) super.set(fieldName, value);
  }

  @Override
  public BackendServiceLogConfig clone() {
    return (BackendServiceLogConfig) super.clone();
  }

}
