/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for DiskResourceStatus.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DiskResourceStatus extends com.google.api.client.json.GenericJson {

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DiskResourceStatusAsyncReplicationStatus asyncPrimaryDisk;

  /**
   * Key: disk, value: AsyncReplicationStatus message
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, DiskResourceStatusAsyncReplicationStatus> asyncSecondaryDisks;

  /**
   * [Output Only] Space used by data stored in the disk (in bytes). Note that this field is set
   * only when the disk is in a storage pool.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long usedBytes;

  /**
   * @return value or {@code null} for none
   */
  public DiskResourceStatusAsyncReplicationStatus getAsyncPrimaryDisk() {
    return asyncPrimaryDisk;
  }

  /**
   * @param asyncPrimaryDisk asyncPrimaryDisk or {@code null} for none
   */
  public DiskResourceStatus setAsyncPrimaryDisk(DiskResourceStatusAsyncReplicationStatus asyncPrimaryDisk) {
    this.asyncPrimaryDisk = asyncPrimaryDisk;
    return this;
  }

  /**
   * Key: disk, value: AsyncReplicationStatus message
   * @return value or {@code null} for none
   */
  public java.util.Map<String, DiskResourceStatusAsyncReplicationStatus> getAsyncSecondaryDisks() {
    return asyncSecondaryDisks;
  }

  /**
   * Key: disk, value: AsyncReplicationStatus message
   * @param asyncSecondaryDisks asyncSecondaryDisks or {@code null} for none
   */
  public DiskResourceStatus setAsyncSecondaryDisks(java.util.Map<String, DiskResourceStatusAsyncReplicationStatus> asyncSecondaryDisks) {
    this.asyncSecondaryDisks = asyncSecondaryDisks;
    return this;
  }

  /**
   * [Output Only] Space used by data stored in the disk (in bytes). Note that this field is set
   * only when the disk is in a storage pool.
   * @return value or {@code null} for none
   */
  public java.lang.Long getUsedBytes() {
    return usedBytes;
  }

  /**
   * [Output Only] Space used by data stored in the disk (in bytes). Note that this field is set
   * only when the disk is in a storage pool.
   * @param usedBytes usedBytes or {@code null} for none
   */
  public DiskResourceStatus setUsedBytes(java.lang.Long usedBytes) {
    this.usedBytes = usedBytes;
    return this;
  }

  @Override
  public DiskResourceStatus set(String fieldName, Object value) {
    return (DiskResourceStatus) super.set(fieldName, value);
  }

  @Override
  public DiskResourceStatus clone() {
    return (DiskResourceStatus) super.clone();
  }

}
