/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * MultiMIG represents a group of Managed Instance Groups.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MultiMig extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTimestamp;

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * [Output Only] Type of the resource. Always compute#multiMig for MultiMIGs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MultiMigLocationPolicy locationPolicy;

  /**
   * Name of the resource. Provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * User-provided names for Parts of MultiMIG and the Parts themselves.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, MultiMigPart> parts;

  /**
   * [Output Only] URL of the region where the resource resides. Only applicable for regional
   * resources. You must specify this field as part of the HTTP request URL. It is not settable as a
   * field in the request body.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String region;

  /**
   * Policy for handling provisioning and other scheduling-related events.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MultiMigSchedulingPolicy schedulingPolicy;

  /**
   * [Output only] Server-defined URL for the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * [Output Only] Server-defined URL for this resource with the resource id.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLinkWithId;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MultiMigStatus status;

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @param creationTimestamp creationTimestamp or {@code null} for none
   */
  public MultiMig setCreationTimestamp(java.lang.String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * @param description description or {@code null} for none
   */
  public MultiMig setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * @param id id or {@code null} for none
   */
  public MultiMig setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * [Output Only] Type of the resource. Always compute#multiMig for MultiMIGs.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output Only] Type of the resource. Always compute#multiMig for MultiMIGs.
   * @param kind kind or {@code null} for none
   */
  public MultiMig setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public MultiMigLocationPolicy getLocationPolicy() {
    return locationPolicy;
  }

  /**
   * @param locationPolicy locationPolicy or {@code null} for none
   */
  public MultiMig setLocationPolicy(MultiMigLocationPolicy locationPolicy) {
    this.locationPolicy = locationPolicy;
    return this;
  }

  /**
   * Name of the resource. Provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the resource. Provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * @param name name or {@code null} for none
   */
  public MultiMig setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * User-provided names for Parts of MultiMIG and the Parts themselves.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, MultiMigPart> getParts() {
    return parts;
  }

  /**
   * User-provided names for Parts of MultiMIG and the Parts themselves.
   * @param parts parts or {@code null} for none
   */
  public MultiMig setParts(java.util.Map<String, MultiMigPart> parts) {
    this.parts = parts;
    return this;
  }

  /**
   * [Output Only] URL of the region where the resource resides. Only applicable for regional
   * resources. You must specify this field as part of the HTTP request URL. It is not settable as a
   * field in the request body.
   * @return value or {@code null} for none
   */
  public java.lang.String getRegion() {
    return region;
  }

  /**
   * [Output Only] URL of the region where the resource resides. Only applicable for regional
   * resources. You must specify this field as part of the HTTP request URL. It is not settable as a
   * field in the request body.
   * @param region region or {@code null} for none
   */
  public MultiMig setRegion(java.lang.String region) {
    this.region = region;
    return this;
  }

  /**
   * Policy for handling provisioning and other scheduling-related events.
   * @return value or {@code null} for none
   */
  public MultiMigSchedulingPolicy getSchedulingPolicy() {
    return schedulingPolicy;
  }

  /**
   * Policy for handling provisioning and other scheduling-related events.
   * @param schedulingPolicy schedulingPolicy or {@code null} for none
   */
  public MultiMig setSchedulingPolicy(MultiMigSchedulingPolicy schedulingPolicy) {
    this.schedulingPolicy = schedulingPolicy;
    return this;
  }

  /**
   * [Output only] Server-defined URL for the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * [Output only] Server-defined URL for the resource.
   * @param selfLink selfLink or {@code null} for none
   */
  public MultiMig setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * [Output Only] Server-defined URL for this resource with the resource id.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLinkWithId() {
    return selfLinkWithId;
  }

  /**
   * [Output Only] Server-defined URL for this resource with the resource id.
   * @param selfLinkWithId selfLinkWithId or {@code null} for none
   */
  public MultiMig setSelfLinkWithId(java.lang.String selfLinkWithId) {
    this.selfLinkWithId = selfLinkWithId;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public MultiMigStatus getStatus() {
    return status;
  }

  /**
   * @param status status or {@code null} for none
   */
  public MultiMig setStatus(MultiMigStatus status) {
    this.status = status;
    return this;
  }

  @Override
  public MultiMig set(String fieldName, Object value) {
    return (MultiMig) super.set(fieldName, value);
  }

  @Override
  public MultiMig clone() {
    return (MultiMig) super.clone();
  }

}
