/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for FutureReservationSpecificSKUProperties.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FutureReservationSpecificSKUProperties extends com.google.api.client.json.GenericJson {

  /**
   * Properties of the SKU instances being reserved.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AllocationSpecificSKUAllocationReservedInstanceProperties instanceProperties;

  /**
   * The instance template that will be used to populate the ReservedInstanceProperties of the
   * future reservation
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sourceInstanceTemplate;

  /**
   * Total number of instances for which capacity assurance is requested at a future time period.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long totalCount;

  /**
   * Properties of the SKU instances being reserved.
   * @return value or {@code null} for none
   */
  public AllocationSpecificSKUAllocationReservedInstanceProperties getInstanceProperties() {
    return instanceProperties;
  }

  /**
   * Properties of the SKU instances being reserved.
   * @param instanceProperties instanceProperties or {@code null} for none
   */
  public FutureReservationSpecificSKUProperties setInstanceProperties(AllocationSpecificSKUAllocationReservedInstanceProperties instanceProperties) {
    this.instanceProperties = instanceProperties;
    return this;
  }

  /**
   * The instance template that will be used to populate the ReservedInstanceProperties of the
   * future reservation
   * @return value or {@code null} for none
   */
  public java.lang.String getSourceInstanceTemplate() {
    return sourceInstanceTemplate;
  }

  /**
   * The instance template that will be used to populate the ReservedInstanceProperties of the
   * future reservation
   * @param sourceInstanceTemplate sourceInstanceTemplate or {@code null} for none
   */
  public FutureReservationSpecificSKUProperties setSourceInstanceTemplate(java.lang.String sourceInstanceTemplate) {
    this.sourceInstanceTemplate = sourceInstanceTemplate;
    return this;
  }

  /**
   * Total number of instances for which capacity assurance is requested at a future time period.
   * @return value or {@code null} for none
   */
  public java.lang.Long getTotalCount() {
    return totalCount;
  }

  /**
   * Total number of instances for which capacity assurance is requested at a future time period.
   * @param totalCount totalCount or {@code null} for none
   */
  public FutureReservationSpecificSKUProperties setTotalCount(java.lang.Long totalCount) {
    this.totalCount = totalCount;
    return this;
  }

  @Override
  public FutureReservationSpecificSKUProperties set(String fieldName, Object value) {
    return (FutureReservationSpecificSKUProperties) super.set(fieldName, value);
  }

  @Override
  public FutureReservationSpecificSKUProperties clone() {
    return (FutureReservationSpecificSKUProperties) super.clone();
  }

}
