/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * The properties of the last known good state for the Future Reservation.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FutureReservationStatusLastKnownGoodStateFutureReservationSpecs extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] The previous share settings of the Future Reservation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ShareSettings shareSettings;

  /**
   * [Output Only] The previous instance related properties of the Future Reservation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FutureReservationSpecificSKUProperties specificSkuProperties;

  /**
   * [Output Only] The previous time window of the Future Reservation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FutureReservationTimeWindow timeWindow;

  /**
   * [Output Only] The previous share settings of the Future Reservation.
   * @return value or {@code null} for none
   */
  public ShareSettings getShareSettings() {
    return shareSettings;
  }

  /**
   * [Output Only] The previous share settings of the Future Reservation.
   * @param shareSettings shareSettings or {@code null} for none
   */
  public FutureReservationStatusLastKnownGoodStateFutureReservationSpecs setShareSettings(ShareSettings shareSettings) {
    this.shareSettings = shareSettings;
    return this;
  }

  /**
   * [Output Only] The previous instance related properties of the Future Reservation.
   * @return value or {@code null} for none
   */
  public FutureReservationSpecificSKUProperties getSpecificSkuProperties() {
    return specificSkuProperties;
  }

  /**
   * [Output Only] The previous instance related properties of the Future Reservation.
   * @param specificSkuProperties specificSkuProperties or {@code null} for none
   */
  public FutureReservationStatusLastKnownGoodStateFutureReservationSpecs setSpecificSkuProperties(FutureReservationSpecificSKUProperties specificSkuProperties) {
    this.specificSkuProperties = specificSkuProperties;
    return this;
  }

  /**
   * [Output Only] The previous time window of the Future Reservation.
   * @return value or {@code null} for none
   */
  public FutureReservationTimeWindow getTimeWindow() {
    return timeWindow;
  }

  /**
   * [Output Only] The previous time window of the Future Reservation.
   * @param timeWindow timeWindow or {@code null} for none
   */
  public FutureReservationStatusLastKnownGoodStateFutureReservationSpecs setTimeWindow(FutureReservationTimeWindow timeWindow) {
    this.timeWindow = timeWindow;
    return this;
  }

  @Override
  public FutureReservationStatusLastKnownGoodStateFutureReservationSpecs set(String fieldName, Object value) {
    return (FutureReservationStatusLastKnownGoodStateFutureReservationSpecs) super.set(fieldName, value);
  }

  @Override
  public FutureReservationStatusLastKnownGoodStateFutureReservationSpecs clone() {
    return (FutureReservationStatusLastKnownGoodStateFutureReservationSpecs) super.clone();
  }

}
