/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for InstanceGroupManagerInstanceFlexibilityPolicy.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InstanceGroupManagerInstanceFlexibilityPolicy extends com.google.api.client.json.GenericJson {

  /**
   * Named instance selections configuring properties that the group will use when creating new VMs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, InstanceGroupManagerInstanceFlexibilityPolicyInstanceSelection> instanceSelectionLists;

  /**
   * Named instance selections configuring properties that the group will use when creating new VMs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, InstanceGroupManagerInstanceFlexibilityPolicyInstanceSelection> instanceSelections;

  /**
   * Provisioning model configuration used by this managed instance group to create instances.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InstanceGroupManagerInstanceFlexibilityPolicyProvisioningModelMix provisioningModelMix;

  /**
   * Named instance selections configuring properties that the group will use when creating new VMs.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, InstanceGroupManagerInstanceFlexibilityPolicyInstanceSelection> getInstanceSelectionLists() {
    return instanceSelectionLists;
  }

  /**
   * Named instance selections configuring properties that the group will use when creating new VMs.
   * @param instanceSelectionLists instanceSelectionLists or {@code null} for none
   */
  public InstanceGroupManagerInstanceFlexibilityPolicy setInstanceSelectionLists(java.util.Map<String, InstanceGroupManagerInstanceFlexibilityPolicyInstanceSelection> instanceSelectionLists) {
    this.instanceSelectionLists = instanceSelectionLists;
    return this;
  }

  /**
   * Named instance selections configuring properties that the group will use when creating new VMs.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, InstanceGroupManagerInstanceFlexibilityPolicyInstanceSelection> getInstanceSelections() {
    return instanceSelections;
  }

  /**
   * Named instance selections configuring properties that the group will use when creating new VMs.
   * @param instanceSelections instanceSelections or {@code null} for none
   */
  public InstanceGroupManagerInstanceFlexibilityPolicy setInstanceSelections(java.util.Map<String, InstanceGroupManagerInstanceFlexibilityPolicyInstanceSelection> instanceSelections) {
    this.instanceSelections = instanceSelections;
    return this;
  }

  /**
   * Provisioning model configuration used by this managed instance group to create instances.
   * @return value or {@code null} for none
   */
  public InstanceGroupManagerInstanceFlexibilityPolicyProvisioningModelMix getProvisioningModelMix() {
    return provisioningModelMix;
  }

  /**
   * Provisioning model configuration used by this managed instance group to create instances.
   * @param provisioningModelMix provisioningModelMix or {@code null} for none
   */
  public InstanceGroupManagerInstanceFlexibilityPolicy setProvisioningModelMix(InstanceGroupManagerInstanceFlexibilityPolicyProvisioningModelMix provisioningModelMix) {
    this.provisioningModelMix = provisioningModelMix;
    return this;
  }

  @Override
  public InstanceGroupManagerInstanceFlexibilityPolicy set(String fieldName, Object value) {
    return (InstanceGroupManagerInstanceFlexibilityPolicy) super.set(fieldName, value);
  }

  @Override
  public InstanceGroupManagerInstanceFlexibilityPolicy clone() {
    return (InstanceGroupManagerInstanceFlexibilityPolicy) super.clone();
  }

}
