/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for InstanceGroupManagerInstanceFlexibilityPolicyProvisioningModelMix.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InstanceGroupManagerInstanceFlexibilityPolicyProvisioningModelMix extends com.google.api.client.json.GenericJson {

  /**
   * The base capacity that will always use Standard VMs to avoid risk of more preemption than the
   * minimum capacity user needs. MIG will create only Standard VMs until it reaches
   * standard_capacity_base and only then will start using standard_capacity_percent_above_base to
   * mix Spot with Standard VMs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer standardCapacityBase;

  /**
   * The percentage of target capacity that should use Standard VM. The remaining percentage will
   * use Spot VMs. The percentage applies only to the capacity above standard_capacity_base.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer standardCapacityPercentAboveBase;

  /**
   * The base capacity that will always use Standard VMs to avoid risk of more preemption than the
   * minimum capacity user needs. MIG will create only Standard VMs until it reaches
   * standard_capacity_base and only then will start using standard_capacity_percent_above_base to
   * mix Spot with Standard VMs.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getStandardCapacityBase() {
    return standardCapacityBase;
  }

  /**
   * The base capacity that will always use Standard VMs to avoid risk of more preemption than the
   * minimum capacity user needs. MIG will create only Standard VMs until it reaches
   * standard_capacity_base and only then will start using standard_capacity_percent_above_base to
   * mix Spot with Standard VMs.
   * @param standardCapacityBase standardCapacityBase or {@code null} for none
   */
  public InstanceGroupManagerInstanceFlexibilityPolicyProvisioningModelMix setStandardCapacityBase(java.lang.Integer standardCapacityBase) {
    this.standardCapacityBase = standardCapacityBase;
    return this;
  }

  /**
   * The percentage of target capacity that should use Standard VM. The remaining percentage will
   * use Spot VMs. The percentage applies only to the capacity above standard_capacity_base.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getStandardCapacityPercentAboveBase() {
    return standardCapacityPercentAboveBase;
  }

  /**
   * The percentage of target capacity that should use Standard VM. The remaining percentage will
   * use Spot VMs. The percentage applies only to the capacity above standard_capacity_base.
   * @param standardCapacityPercentAboveBase standardCapacityPercentAboveBase or {@code null} for none
   */
  public InstanceGroupManagerInstanceFlexibilityPolicyProvisioningModelMix setStandardCapacityPercentAboveBase(java.lang.Integer standardCapacityPercentAboveBase) {
    this.standardCapacityPercentAboveBase = standardCapacityPercentAboveBase;
    return this;
  }

  @Override
  public InstanceGroupManagerInstanceFlexibilityPolicyProvisioningModelMix set(String fieldName, Object value) {
    return (InstanceGroupManagerInstanceFlexibilityPolicyProvisioningModelMix) super.set(fieldName, value);
  }

  @Override
  public InstanceGroupManagerInstanceFlexibilityPolicyProvisioningModelMix clone() {
    return (InstanceGroupManagerInstanceFlexibilityPolicyProvisioningModelMix) super.clone();
  }

}
