/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for InstanceGroupManagerResizeRequestStatus.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InstanceGroupManagerResizeRequestStatus extends com.google.api.client.json.GenericJson {

  /**
   * [Output only] Fatal errors encountered during the queueing or provisioning phases of the
   * ResizeRequest that caused the transition to the FAILED state. Contrary to the last_attempt
   * errors, this field is final and errors are never removed from here, as the ResizeRequest is not
   * going to retry.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Error error;

  /**
   * [Output only] Information about the last attempt to fulfill the request. The value is temporary
   * since the ResizeRequest can retry, as long as it's still active and the last attempt value can
   * either be cleared or replaced with a different error. Since ResizeRequest retries infrequently,
   * the value may be stale and no longer show an active problem. The value is cleared when
   * ResizeRequest transitions to the final state (becomes inactive). If the final state is FAILED
   * the error describing it will be storred in the "error" field only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InstanceGroupManagerResizeRequestStatusLastAttempt lastAttempt;

  /**
   * This field is deprecated, setting queueing policy is no longer supported. Constraints for the
   * time when the instances start provisioning. Always exposed as absolute time.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private QueuingPolicy queuingPolicy;

  /**
   * [Output only] Fatal errors encountered during the queueing or provisioning phases of the
   * ResizeRequest that caused the transition to the FAILED state. Contrary to the last_attempt
   * errors, this field is final and errors are never removed from here, as the ResizeRequest is not
   * going to retry.
   * @return value or {@code null} for none
   */
  public Error getError() {
    return error;
  }

  /**
   * [Output only] Fatal errors encountered during the queueing or provisioning phases of the
   * ResizeRequest that caused the transition to the FAILED state. Contrary to the last_attempt
   * errors, this field is final and errors are never removed from here, as the ResizeRequest is not
   * going to retry.
   * @param error error or {@code null} for none
   */
  public InstanceGroupManagerResizeRequestStatus setError(Error error) {
    this.error = error;
    return this;
  }

  /**
   * [Output only] Information about the last attempt to fulfill the request. The value is temporary
   * since the ResizeRequest can retry, as long as it's still active and the last attempt value can
   * either be cleared or replaced with a different error. Since ResizeRequest retries infrequently,
   * the value may be stale and no longer show an active problem. The value is cleared when
   * ResizeRequest transitions to the final state (becomes inactive). If the final state is FAILED
   * the error describing it will be storred in the "error" field only.
   * @return value or {@code null} for none
   */
  public InstanceGroupManagerResizeRequestStatusLastAttempt getLastAttempt() {
    return lastAttempt;
  }

  /**
   * [Output only] Information about the last attempt to fulfill the request. The value is temporary
   * since the ResizeRequest can retry, as long as it's still active and the last attempt value can
   * either be cleared or replaced with a different error. Since ResizeRequest retries infrequently,
   * the value may be stale and no longer show an active problem. The value is cleared when
   * ResizeRequest transitions to the final state (becomes inactive). If the final state is FAILED
   * the error describing it will be storred in the "error" field only.
   * @param lastAttempt lastAttempt or {@code null} for none
   */
  public InstanceGroupManagerResizeRequestStatus setLastAttempt(InstanceGroupManagerResizeRequestStatusLastAttempt lastAttempt) {
    this.lastAttempt = lastAttempt;
    return this;
  }

  /**
   * This field is deprecated, setting queueing policy is no longer supported. Constraints for the
   * time when the instances start provisioning. Always exposed as absolute time.
   * @return value or {@code null} for none
   */
  public QueuingPolicy getQueuingPolicy() {
    return queuingPolicy;
  }

  /**
   * This field is deprecated, setting queueing policy is no longer supported. Constraints for the
   * time when the instances start provisioning. Always exposed as absolute time.
   * @param queuingPolicy queuingPolicy or {@code null} for none
   */
  public InstanceGroupManagerResizeRequestStatus setQueuingPolicy(QueuingPolicy queuingPolicy) {
    this.queuingPolicy = queuingPolicy;
    return this;
  }

  @Override
  public InstanceGroupManagerResizeRequestStatus set(String fieldName, Object value) {
    return (InstanceGroupManagerResizeRequestStatus) super.set(fieldName, value);
  }

  @Override
  public InstanceGroupManagerResizeRequestStatus clone() {
    return (InstanceGroupManagerResizeRequestStatus) super.clone();
  }

  /**
   * [Output only] Fatal errors encountered during the queueing or provisioning phases of the
   * ResizeRequest that caused the transition to the FAILED state. Contrary to the last_attempt
   * errors, this field is final and errors are never removed from here, as the ResizeRequest is not
   * going to retry.
   */
  public static final class Error extends com.google.api.client.json.GenericJson {

    /**
     * [Output Only] The array of errors encountered while processing this operation.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<Errors> errors;

    static {
      // hack to force ProGuard to consider Errors used, since otherwise it would be stripped out
      // see https://github.com/google/google-api-java-client/issues/543
      com.google.api.client.util.Data.nullOf(Errors.class);
    }

    /**
     * [Output Only] The array of errors encountered while processing this operation.
     * @return value or {@code null} for none
     */
    public java.util.List<Errors> getErrors() {
      return errors;
    }

    /**
     * [Output Only] The array of errors encountered while processing this operation.
     * @param errors errors or {@code null} for none
     */
    public Error setErrors(java.util.List<Errors> errors) {
      this.errors = errors;
      return this;
    }

    @Override
    public Error set(String fieldName, Object value) {
      return (Error) super.set(fieldName, value);
    }

    @Override
    public Error clone() {
      return (Error) super.clone();
    }

    /**
     * Model definition for InstanceGroupManagerResizeRequestStatusErrorErrors.
     */
    public static final class Errors extends com.google.api.client.json.GenericJson {

      /**
       * [Output Only] The error type identifier for this error.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String code;

      /**
       * [Output Only] An optional list of messages that contain the error details. There is a set of
       * defined message types to use for providing details.The syntax depends on the error code. For
       * example, QuotaExceededInfo will have details when the error code is QUOTA_EXCEEDED.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.util.List<ErrorDetails> errorDetails;

      static {
        // hack to force ProGuard to consider ErrorDetails used, since otherwise it would be stripped out
        // see https://github.com/google/google-api-java-client/issues/543
        com.google.api.client.util.Data.nullOf(ErrorDetails.class);
      }

      /**
       * [Output Only] Indicates the field in the request that caused the error. This property is
       * optional.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String location;

      /**
       * [Output Only] An optional, human-readable error message.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String message;

      /**
       * [Output Only] The error type identifier for this error.
       * @return value or {@code null} for none
       */
      public java.lang.String getCode() {
        return code;
      }

      /**
       * [Output Only] The error type identifier for this error.
       * @param code code or {@code null} for none
       */
      public Errors setCode(java.lang.String code) {
        this.code = code;
        return this;
      }

      /**
       * [Output Only] An optional list of messages that contain the error details. There is a set of
       * defined message types to use for providing details.The syntax depends on the error code. For
       * example, QuotaExceededInfo will have details when the error code is QUOTA_EXCEEDED.
       * @return value or {@code null} for none
       */
      public java.util.List<ErrorDetails> getErrorDetails() {
        return errorDetails;
      }

      /**
       * [Output Only] An optional list of messages that contain the error details. There is a set of
       * defined message types to use for providing details.The syntax depends on the error code. For
       * example, QuotaExceededInfo will have details when the error code is QUOTA_EXCEEDED.
       * @param errorDetails errorDetails or {@code null} for none
       */
      public Errors setErrorDetails(java.util.List<ErrorDetails> errorDetails) {
        this.errorDetails = errorDetails;
        return this;
      }

      /**
       * [Output Only] Indicates the field in the request that caused the error. This property is
       * optional.
       * @return value or {@code null} for none
       */
      public java.lang.String getLocation() {
        return location;
      }

      /**
       * [Output Only] Indicates the field in the request that caused the error. This property is
       * optional.
       * @param location location or {@code null} for none
       */
      public Errors setLocation(java.lang.String location) {
        this.location = location;
        return this;
      }

      /**
       * [Output Only] An optional, human-readable error message.
       * @return value or {@code null} for none
       */
      public java.lang.String getMessage() {
        return message;
      }

      /**
       * [Output Only] An optional, human-readable error message.
       * @param message message or {@code null} for none
       */
      public Errors setMessage(java.lang.String message) {
        this.message = message;
        return this;
      }

      @Override
      public Errors set(String fieldName, Object value) {
        return (Errors) super.set(fieldName, value);
      }

      @Override
      public Errors clone() {
        return (Errors) super.clone();
      }

      /**
       * Model definition for InstanceGroupManagerResizeRequestStatusErrorErrorsErrorDetails.
       */
      public static final class ErrorDetails extends com.google.api.client.json.GenericJson {

        /**
         * The value may be {@code null}.
         */
        @com.google.api.client.util.Key
        private ErrorInfo errorInfo;

        /**
         * The value may be {@code null}.
         */
        @com.google.api.client.util.Key
        private Help help;

        /**
         * The value may be {@code null}.
         */
        @com.google.api.client.util.Key
        private LocalizedMessage localizedMessage;

        /**
         * The value may be {@code null}.
         */
        @com.google.api.client.util.Key
        private QuotaExceededInfo quotaInfo;

        /**
         * @return value or {@code null} for none
         */
        public ErrorInfo getErrorInfo() {
          return errorInfo;
        }

        /**
         * @param errorInfo errorInfo or {@code null} for none
         */
        public ErrorDetails setErrorInfo(ErrorInfo errorInfo) {
          this.errorInfo = errorInfo;
          return this;
        }

        /**
         * @return value or {@code null} for none
         */
        public Help getHelp() {
          return help;
        }

        /**
         * @param help help or {@code null} for none
         */
        public ErrorDetails setHelp(Help help) {
          this.help = help;
          return this;
        }

        /**
         * @return value or {@code null} for none
         */
        public LocalizedMessage getLocalizedMessage() {
          return localizedMessage;
        }

        /**
         * @param localizedMessage localizedMessage or {@code null} for none
         */
        public ErrorDetails setLocalizedMessage(LocalizedMessage localizedMessage) {
          this.localizedMessage = localizedMessage;
          return this;
        }

        /**
         * @return value or {@code null} for none
         */
        public QuotaExceededInfo getQuotaInfo() {
          return quotaInfo;
        }

        /**
         * @param quotaInfo quotaInfo or {@code null} for none
         */
        public ErrorDetails setQuotaInfo(QuotaExceededInfo quotaInfo) {
          this.quotaInfo = quotaInfo;
          return this;
        }

        @Override
        public ErrorDetails set(String fieldName, Object value) {
          return (ErrorDetails) super.set(fieldName, value);
        }

        @Override
        public ErrorDetails clone() {
          return (ErrorDetails) super.clone();
        }

      }
    }
  }
}
