/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for LocationPolicyLocation.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LocationPolicyLocation extends com.google.api.client.json.GenericJson {

  /**
   * Constraints that the caller requires on the result distribution in this zone.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocationPolicyLocationConstraints constraints;

  /**
   * Names of resources to be put in the location. Must contain unique, correct resource names. If
   * used, targetShape must be left unset.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> names;

  /**
   * Preference for a given location. Set to either ALLOW or DENY.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String preference;

  /**
   * Constraints that the caller requires on the result distribution in this zone.
   * @return value or {@code null} for none
   */
  public LocationPolicyLocationConstraints getConstraints() {
    return constraints;
  }

  /**
   * Constraints that the caller requires on the result distribution in this zone.
   * @param constraints constraints or {@code null} for none
   */
  public LocationPolicyLocation setConstraints(LocationPolicyLocationConstraints constraints) {
    this.constraints = constraints;
    return this;
  }

  /**
   * Names of resources to be put in the location. Must contain unique, correct resource names. If
   * used, targetShape must be left unset.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getNames() {
    return names;
  }

  /**
   * Names of resources to be put in the location. Must contain unique, correct resource names. If
   * used, targetShape must be left unset.
   * @param names names or {@code null} for none
   */
  public LocationPolicyLocation setNames(java.util.List<java.lang.String> names) {
    this.names = names;
    return this;
  }

  /**
   * Preference for a given location. Set to either ALLOW or DENY.
   * @return value or {@code null} for none
   */
  public java.lang.String getPreference() {
    return preference;
  }

  /**
   * Preference for a given location. Set to either ALLOW or DENY.
   * @param preference preference or {@code null} for none
   */
  public LocationPolicyLocation setPreference(java.lang.String preference) {
    this.preference = preference;
    return this;
  }

  @Override
  public LocationPolicyLocation set(String fieldName, Object value) {
    return (LocationPolicyLocation) super.set(fieldName, value);
  }

  @Override
  public LocationPolicyLocation clone() {
    return (LocationPolicyLocation) super.clone();
  }

}
