/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for ServiceAttachmentConsumerProjectLimit.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ServiceAttachmentConsumerProjectLimit extends com.google.api.client.json.GenericJson {

  /**
   * The value of the limit to set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long connectionLimit;

  /**
   * The network URL for the network to set the limit for.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String networkUrl;

  /**
   * The project id or number for the project to set the limit for.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String projectIdOrNum;

  /**
   * The value of the limit to set.
   * @return value or {@code null} for none
   */
  public java.lang.Long getConnectionLimit() {
    return connectionLimit;
  }

  /**
   * The value of the limit to set.
   * @param connectionLimit connectionLimit or {@code null} for none
   */
  public ServiceAttachmentConsumerProjectLimit setConnectionLimit(java.lang.Long connectionLimit) {
    this.connectionLimit = connectionLimit;
    return this;
  }

  /**
   * The network URL for the network to set the limit for.
   * @return value or {@code null} for none
   */
  public java.lang.String getNetworkUrl() {
    return networkUrl;
  }

  /**
   * The network URL for the network to set the limit for.
   * @param networkUrl networkUrl or {@code null} for none
   */
  public ServiceAttachmentConsumerProjectLimit setNetworkUrl(java.lang.String networkUrl) {
    this.networkUrl = networkUrl;
    return this;
  }

  /**
   * The project id or number for the project to set the limit for.
   * @return value or {@code null} for none
   */
  public java.lang.String getProjectIdOrNum() {
    return projectIdOrNum;
  }

  /**
   * The project id or number for the project to set the limit for.
   * @param projectIdOrNum projectIdOrNum or {@code null} for none
   */
  public ServiceAttachmentConsumerProjectLimit setProjectIdOrNum(java.lang.String projectIdOrNum) {
    this.projectIdOrNum = projectIdOrNum;
    return this;
  }

  @Override
  public ServiceAttachmentConsumerProjectLimit set(String fieldName, Object value) {
    return (ServiceAttachmentConsumerProjectLimit) super.set(fieldName, value);
  }

  @Override
  public ServiceAttachmentConsumerProjectLimit clone() {
    return (ServiceAttachmentConsumerProjectLimit) super.clone();
  }

}
