/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * An InstanceSchedulePolicy specifies when and how frequent certain operations are performed on the
 * instance.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ResourcePolicyInstanceSchedulePolicy extends com.google.api.client.json.GenericJson {

  /**
   * The expiration time of the schedule. The timestamp is an RFC3339 string.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String expirationTime;

  /**
   * The start time of the schedule. The timestamp is an RFC3339 string.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String startTime;

  /**
   * Specifies the time zone to be used in interpreting Schedule.schedule. The value of this field
   * must be a time zone name from the tz database: https://wikipedia.org/wiki/Tz_database.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String timeZone;

  /**
   * Specifies the schedule for starting instances.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ResourcePolicyInstanceSchedulePolicySchedule vmStartSchedule;

  /**
   * Specifies the schedule for stopping instances.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ResourcePolicyInstanceSchedulePolicySchedule vmStopSchedule;

  /**
   * The expiration time of the schedule. The timestamp is an RFC3339 string.
   * @return value or {@code null} for none
   */
  public java.lang.String getExpirationTime() {
    return expirationTime;
  }

  /**
   * The expiration time of the schedule. The timestamp is an RFC3339 string.
   * @param expirationTime expirationTime or {@code null} for none
   */
  public ResourcePolicyInstanceSchedulePolicy setExpirationTime(java.lang.String expirationTime) {
    this.expirationTime = expirationTime;
    return this;
  }

  /**
   * The start time of the schedule. The timestamp is an RFC3339 string.
   * @return value or {@code null} for none
   */
  public java.lang.String getStartTime() {
    return startTime;
  }

  /**
   * The start time of the schedule. The timestamp is an RFC3339 string.
   * @param startTime startTime or {@code null} for none
   */
  public ResourcePolicyInstanceSchedulePolicy setStartTime(java.lang.String startTime) {
    this.startTime = startTime;
    return this;
  }

  /**
   * Specifies the time zone to be used in interpreting Schedule.schedule. The value of this field
   * must be a time zone name from the tz database: https://wikipedia.org/wiki/Tz_database.
   * @return value or {@code null} for none
   */
  public java.lang.String getTimeZone() {
    return timeZone;
  }

  /**
   * Specifies the time zone to be used in interpreting Schedule.schedule. The value of this field
   * must be a time zone name from the tz database: https://wikipedia.org/wiki/Tz_database.
   * @param timeZone timeZone or {@code null} for none
   */
  public ResourcePolicyInstanceSchedulePolicy setTimeZone(java.lang.String timeZone) {
    this.timeZone = timeZone;
    return this;
  }

  /**
   * Specifies the schedule for starting instances.
   * @return value or {@code null} for none
   */
  public ResourcePolicyInstanceSchedulePolicySchedule getVmStartSchedule() {
    return vmStartSchedule;
  }

  /**
   * Specifies the schedule for starting instances.
   * @param vmStartSchedule vmStartSchedule or {@code null} for none
   */
  public ResourcePolicyInstanceSchedulePolicy setVmStartSchedule(ResourcePolicyInstanceSchedulePolicySchedule vmStartSchedule) {
    this.vmStartSchedule = vmStartSchedule;
    return this;
  }

  /**
   * Specifies the schedule for stopping instances.
   * @return value or {@code null} for none
   */
  public ResourcePolicyInstanceSchedulePolicySchedule getVmStopSchedule() {
    return vmStopSchedule;
  }

  /**
   * Specifies the schedule for stopping instances.
   * @param vmStopSchedule vmStopSchedule or {@code null} for none
   */
  public ResourcePolicyInstanceSchedulePolicy setVmStopSchedule(ResourcePolicyInstanceSchedulePolicySchedule vmStopSchedule) {
    this.vmStopSchedule = vmStopSchedule;
    return this;
  }

  @Override
  public ResourcePolicyInstanceSchedulePolicy set(String fieldName, Object value) {
    return (ResourcePolicyInstanceSchedulePolicy) super.set(fieldName, value);
  }

  @Override
  public ResourcePolicyInstanceSchedulePolicy clone() {
    return (ResourcePolicyInstanceSchedulePolicy) super.clone();
  }

}
