/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for StoragePoolDisk.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class StoragePoolDisk extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] Instances this disk is attached to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> attachedInstances;

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTimestamp;

  /**
   * [Output Only] The URL of the disk.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String disk;

  /**
   * [Output Only] The name of the disk.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * [Output Only] The number of IOPS provisioned for the disk.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long provisionedIops;

  /**
   * [Output Only] The throughput provisioned for the disk.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long provisionedThroughput;

  /**
   * [Output Only] Resource policies applied to disk for automatic snapshot creations.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> resourcePolicies;

  /**
   * [Output Only] The disk size, in GB.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long sizeGb;

  /**
   * [Output Only] The disk status.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * [Output Only] The disk type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * [Output Only] Amount of disk space used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long usedBytes;

  /**
   * [Output Only] Instances this disk is attached to.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getAttachedInstances() {
    return attachedInstances;
  }

  /**
   * [Output Only] Instances this disk is attached to.
   * @param attachedInstances attachedInstances or {@code null} for none
   */
  public StoragePoolDisk setAttachedInstances(java.util.List<java.lang.String> attachedInstances) {
    this.attachedInstances = attachedInstances;
    return this;
  }

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @param creationTimestamp creationTimestamp or {@code null} for none
   */
  public StoragePoolDisk setCreationTimestamp(java.lang.String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * [Output Only] The URL of the disk.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisk() {
    return disk;
  }

  /**
   * [Output Only] The URL of the disk.
   * @param disk disk or {@code null} for none
   */
  public StoragePoolDisk setDisk(java.lang.String disk) {
    this.disk = disk;
    return this;
  }

  /**
   * [Output Only] The name of the disk.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * [Output Only] The name of the disk.
   * @param name name or {@code null} for none
   */
  public StoragePoolDisk setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * [Output Only] The number of IOPS provisioned for the disk.
   * @return value or {@code null} for none
   */
  public java.lang.Long getProvisionedIops() {
    return provisionedIops;
  }

  /**
   * [Output Only] The number of IOPS provisioned for the disk.
   * @param provisionedIops provisionedIops or {@code null} for none
   */
  public StoragePoolDisk setProvisionedIops(java.lang.Long provisionedIops) {
    this.provisionedIops = provisionedIops;
    return this;
  }

  /**
   * [Output Only] The throughput provisioned for the disk.
   * @return value or {@code null} for none
   */
  public java.lang.Long getProvisionedThroughput() {
    return provisionedThroughput;
  }

  /**
   * [Output Only] The throughput provisioned for the disk.
   * @param provisionedThroughput provisionedThroughput or {@code null} for none
   */
  public StoragePoolDisk setProvisionedThroughput(java.lang.Long provisionedThroughput) {
    this.provisionedThroughput = provisionedThroughput;
    return this;
  }

  /**
   * [Output Only] Resource policies applied to disk for automatic snapshot creations.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getResourcePolicies() {
    return resourcePolicies;
  }

  /**
   * [Output Only] Resource policies applied to disk for automatic snapshot creations.
   * @param resourcePolicies resourcePolicies or {@code null} for none
   */
  public StoragePoolDisk setResourcePolicies(java.util.List<java.lang.String> resourcePolicies) {
    this.resourcePolicies = resourcePolicies;
    return this;
  }

  /**
   * [Output Only] The disk size, in GB.
   * @return value or {@code null} for none
   */
  public java.lang.Long getSizeGb() {
    return sizeGb;
  }

  /**
   * [Output Only] The disk size, in GB.
   * @param sizeGb sizeGb or {@code null} for none
   */
  public StoragePoolDisk setSizeGb(java.lang.Long sizeGb) {
    this.sizeGb = sizeGb;
    return this;
  }

  /**
   * [Output Only] The disk status.
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * [Output Only] The disk status.
   * @param status status or {@code null} for none
   */
  public StoragePoolDisk setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  /**
   * [Output Only] The disk type.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * [Output Only] The disk type.
   * @param type type or {@code null} for none
   */
  public StoragePoolDisk setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  /**
   * [Output Only] Amount of disk space used.
   * @return value or {@code null} for none
   */
  public java.lang.Long getUsedBytes() {
    return usedBytes;
  }

  /**
   * [Output Only] Amount of disk space used.
   * @param usedBytes usedBytes or {@code null} for none
   */
  public StoragePoolDisk setUsedBytes(java.lang.Long usedBytes) {
    this.usedBytes = usedBytes;
    return this;
  }

  @Override
  public StoragePoolDisk set(String fieldName, Object value) {
    return (StoragePoolDisk) super.set(fieldName, value);
  }

  @Override
  public StoragePoolDisk clone() {
    return (StoragePoolDisk) super.clone();
  }

}
