/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * A Subject Alternative Name that the load balancer matches against the SAN field in the TLS
 * certificate provided by the backend, specified as either a DNS name or a URI, in accordance with
 * RFC 5280 4.2.1.6
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BackendServiceTlsSettingsSubjectAltName extends com.google.api.client.json.GenericJson {

  /**
   * The SAN specified as a DNS Name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dnsName;

  /**
   * The SAN specified as a URI.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String uniformResourceIdentifier;

  /**
   * The SAN specified as a DNS Name.
   * @return value or {@code null} for none
   */
  public java.lang.String getDnsName() {
    return dnsName;
  }

  /**
   * The SAN specified as a DNS Name.
   * @param dnsName dnsName or {@code null} for none
   */
  public BackendServiceTlsSettingsSubjectAltName setDnsName(java.lang.String dnsName) {
    this.dnsName = dnsName;
    return this;
  }

  /**
   * The SAN specified as a URI.
   * @return value or {@code null} for none
   */
  public java.lang.String getUniformResourceIdentifier() {
    return uniformResourceIdentifier;
  }

  /**
   * The SAN specified as a URI.
   * @param uniformResourceIdentifier uniformResourceIdentifier or {@code null} for none
   */
  public BackendServiceTlsSettingsSubjectAltName setUniformResourceIdentifier(java.lang.String uniformResourceIdentifier) {
    this.uniformResourceIdentifier = uniformResourceIdentifier;
    return this;
  }

  @Override
  public BackendServiceTlsSettingsSubjectAltName set(String fieldName, Object value) {
    return (BackendServiceTlsSettingsSubjectAltName) super.set(fieldName, value);
  }

  @Override
  public BackendServiceTlsSettingsSubjectAltName clone() {
    return (BackendServiceTlsSettingsSubjectAltName) super.clone();
  }

}
