/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * A request to recommend the best way to consume the specified resources in the future.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CalendarModeAdviceRequest extends com.google.api.client.json.GenericJson {

  /**
   * Specification of resources to create in the future. The key of the map is an arbitrary string
   * specified by the caller. Value of the map is a specification of required resources and their
   * constraints. Currently only one value is allowed in this map.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, FutureResourcesSpec> futureResourcesSpecs;

  /**
   * Specification of resources to create in the future. The key of the map is an arbitrary string
   * specified by the caller. Value of the map is a specification of required resources and their
   * constraints. Currently only one value is allowed in this map.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, FutureResourcesSpec> getFutureResourcesSpecs() {
    return futureResourcesSpecs;
  }

  /**
   * Specification of resources to create in the future. The key of the map is an arbitrary string
   * specified by the caller. Value of the map is a specification of required resources and their
   * constraints. Currently only one value is allowed in this map.
   * @param futureResourcesSpecs futureResourcesSpecs or {@code null} for none
   */
  public CalendarModeAdviceRequest setFutureResourcesSpecs(java.util.Map<String, FutureResourcesSpec> futureResourcesSpecs) {
    this.futureResourcesSpecs = futureResourcesSpecs;
    return this;
  }

  @Override
  public CalendarModeAdviceRequest set(String fieldName, Object value) {
    return (CalendarModeAdviceRequest) super.set(fieldName, value);
  }

  @Override
  public CalendarModeAdviceRequest clone() {
    return (CalendarModeAdviceRequest) super.clone();
  }

}
