/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * A response containing the recommended way of creating the specified resources in the future. It
 * contains (will contain) multiple recommendations that can be analyzed by the customer and the
 * best one can be picked.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CalendarModeAdviceResponse extends com.google.api.client.json.GenericJson {

  /**
   * Recommendations where, how and when to create the requested resources in order to maximize
   * their obtainability and minimize cost.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<CalendarModeRecommendation> recommendations;

  /**
   * Recommendations where, how and when to create the requested resources in order to maximize
   * their obtainability and minimize cost.
   * @return value or {@code null} for none
   */
  public java.util.List<CalendarModeRecommendation> getRecommendations() {
    return recommendations;
  }

  /**
   * Recommendations where, how and when to create the requested resources in order to maximize
   * their obtainability and minimize cost.
   * @param recommendations recommendations or {@code null} for none
   */
  public CalendarModeAdviceResponse setRecommendations(java.util.List<CalendarModeRecommendation> recommendations) {
    this.recommendations = recommendations;
    return this;
  }

  @Override
  public CalendarModeAdviceResponse set(String fieldName, Object value) {
    return (CalendarModeAdviceResponse) super.set(fieldName, value);
  }

  @Override
  public CalendarModeAdviceResponse clone() {
    return (CalendarModeAdviceResponse) super.clone();
  }

}
