/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * A single recommendation to create requested resources. Contains detailed recommendations for
 * every future resources specification specified in CalendarModeAdviceRequest.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CalendarModeRecommendation extends com.google.api.client.json.GenericJson {

  /**
   * Recommendations for every future resource specification passed in CalendarModeAdviceRequest.
   * Keys of the map correspond to keys specified in the request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, FutureResourcesRecommendation> recommendationsPerSpec;

  /**
   * Recommendations for every future resource specification passed in CalendarModeAdviceRequest.
   * Keys of the map correspond to keys specified in the request.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, FutureResourcesRecommendation> getRecommendationsPerSpec() {
    return recommendationsPerSpec;
  }

  /**
   * Recommendations for every future resource specification passed in CalendarModeAdviceRequest.
   * Keys of the map correspond to keys specified in the request.
   * @param recommendationsPerSpec recommendationsPerSpec or {@code null} for none
   */
  public CalendarModeRecommendation setRecommendationsPerSpec(java.util.Map<String, FutureResourcesRecommendation> recommendationsPerSpec) {
    this.recommendationsPerSpec = recommendationsPerSpec;
    return this;
  }

  @Override
  public CalendarModeRecommendation set(String fieldName, Object value) {
    return (CalendarModeRecommendation) super.set(fieldName, value);
  }

  @Override
  public CalendarModeRecommendation clone() {
    return (CalendarModeRecommendation) super.clone();
  }

}
