/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * The state that the future reservation will be reverted to should the amendment be declined.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FutureReservationStatusLastKnownGoodState extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] The description of the FutureReservation before an amendment was requested.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * [Output Only] Represents the matching usage for the future reservation before an amendment was
   * requested.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FutureReservationStatusExistingMatchingUsageInfo existingMatchingUsageInfo;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FutureReservationStatusLastKnownGoodStateFutureReservationSpecs futureReservationSpecs;

  /**
   * [Output Only] The lock time of the FutureReservation before an amendment was requested.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String lockTime;

  /**
   * [Output Only] The name prefix of the Future Reservation before an amendment was requested.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String namePrefix;

  /**
   * [Output Only] The status of the last known good state for the Future Reservation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String procurementStatus;

  /**
   * [Output Only] The description of the FutureReservation before an amendment was requested.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * [Output Only] The description of the FutureReservation before an amendment was requested.
   * @param description description or {@code null} for none
   */
  public FutureReservationStatusLastKnownGoodState setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * [Output Only] Represents the matching usage for the future reservation before an amendment was
   * requested.
   * @return value or {@code null} for none
   */
  public FutureReservationStatusExistingMatchingUsageInfo getExistingMatchingUsageInfo() {
    return existingMatchingUsageInfo;
  }

  /**
   * [Output Only] Represents the matching usage for the future reservation before an amendment was
   * requested.
   * @param existingMatchingUsageInfo existingMatchingUsageInfo or {@code null} for none
   */
  public FutureReservationStatusLastKnownGoodState setExistingMatchingUsageInfo(FutureReservationStatusExistingMatchingUsageInfo existingMatchingUsageInfo) {
    this.existingMatchingUsageInfo = existingMatchingUsageInfo;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public FutureReservationStatusLastKnownGoodStateFutureReservationSpecs getFutureReservationSpecs() {
    return futureReservationSpecs;
  }

  /**
   * @param futureReservationSpecs futureReservationSpecs or {@code null} for none
   */
  public FutureReservationStatusLastKnownGoodState setFutureReservationSpecs(FutureReservationStatusLastKnownGoodStateFutureReservationSpecs futureReservationSpecs) {
    this.futureReservationSpecs = futureReservationSpecs;
    return this;
  }

  /**
   * [Output Only] The lock time of the FutureReservation before an amendment was requested.
   * @return value or {@code null} for none
   */
  public java.lang.String getLockTime() {
    return lockTime;
  }

  /**
   * [Output Only] The lock time of the FutureReservation before an amendment was requested.
   * @param lockTime lockTime or {@code null} for none
   */
  public FutureReservationStatusLastKnownGoodState setLockTime(java.lang.String lockTime) {
    this.lockTime = lockTime;
    return this;
  }

  /**
   * [Output Only] The name prefix of the Future Reservation before an amendment was requested.
   * @return value or {@code null} for none
   */
  public java.lang.String getNamePrefix() {
    return namePrefix;
  }

  /**
   * [Output Only] The name prefix of the Future Reservation before an amendment was requested.
   * @param namePrefix namePrefix or {@code null} for none
   */
  public FutureReservationStatusLastKnownGoodState setNamePrefix(java.lang.String namePrefix) {
    this.namePrefix = namePrefix;
    return this;
  }

  /**
   * [Output Only] The status of the last known good state for the Future Reservation.
   * @return value or {@code null} for none
   */
  public java.lang.String getProcurementStatus() {
    return procurementStatus;
  }

  /**
   * [Output Only] The status of the last known good state for the Future Reservation.
   * @param procurementStatus procurementStatus or {@code null} for none
   */
  public FutureReservationStatusLastKnownGoodState setProcurementStatus(java.lang.String procurementStatus) {
    this.procurementStatus = procurementStatus;
    return this;
  }

  @Override
  public FutureReservationStatusLastKnownGoodState set(String fieldName, Object value) {
    return (FutureReservationStatusLastKnownGoodState) super.set(fieldName, value);
  }

  @Override
  public FutureReservationStatusLastKnownGoodState clone() {
    return (FutureReservationStatusLastKnownGoodState) super.clone();
  }

}
