/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Specification of resources to be created at some time in the future within an optionally
 * specified set of locations, and within the specified time range.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FutureResourcesSpec extends com.google.api.client.json.GenericJson {

  /**
   * Indicates if the reservation allocation strategy is static (DENSE) or dynamic (STANDARD).
   * Defaults to DENSE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String deploymentType;

  /**
   * Optional location policy allowing to exclude some zone(s) in which the resources must not be
   * created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FutureResourcesSpecLocationPolicy locationPolicy;

  /**
   * Specification of the reserved resources.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FutureResourcesSpecTargetResources targetResources;

  /**
   * Specification of a time range in which the resources may be created. The time range specifies
   * start of resource use and planned end of resource use.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FlexibleTimeRange timeRangeSpec;

  /**
   * Indicates if the reservation allocation strategy is static (DENSE) or dynamic (STANDARD).
   * Defaults to DENSE.
   * @return value or {@code null} for none
   */
  public java.lang.String getDeploymentType() {
    return deploymentType;
  }

  /**
   * Indicates if the reservation allocation strategy is static (DENSE) or dynamic (STANDARD).
   * Defaults to DENSE.
   * @param deploymentType deploymentType or {@code null} for none
   */
  public FutureResourcesSpec setDeploymentType(java.lang.String deploymentType) {
    this.deploymentType = deploymentType;
    return this;
  }

  /**
   * Optional location policy allowing to exclude some zone(s) in which the resources must not be
   * created.
   * @return value or {@code null} for none
   */
  public FutureResourcesSpecLocationPolicy getLocationPolicy() {
    return locationPolicy;
  }

  /**
   * Optional location policy allowing to exclude some zone(s) in which the resources must not be
   * created.
   * @param locationPolicy locationPolicy or {@code null} for none
   */
  public FutureResourcesSpec setLocationPolicy(FutureResourcesSpecLocationPolicy locationPolicy) {
    this.locationPolicy = locationPolicy;
    return this;
  }

  /**
   * Specification of the reserved resources.
   * @return value or {@code null} for none
   */
  public FutureResourcesSpecTargetResources getTargetResources() {
    return targetResources;
  }

  /**
   * Specification of the reserved resources.
   * @param targetResources targetResources or {@code null} for none
   */
  public FutureResourcesSpec setTargetResources(FutureResourcesSpecTargetResources targetResources) {
    this.targetResources = targetResources;
    return this;
  }

  /**
   * Specification of a time range in which the resources may be created. The time range specifies
   * start of resource use and planned end of resource use.
   * @return value or {@code null} for none
   */
  public FlexibleTimeRange getTimeRangeSpec() {
    return timeRangeSpec;
  }

  /**
   * Specification of a time range in which the resources may be created. The time range specifies
   * start of resource use and planned end of resource use.
   * @param timeRangeSpec timeRangeSpec or {@code null} for none
   */
  public FutureResourcesSpec setTimeRangeSpec(FlexibleTimeRange timeRangeSpec) {
    this.timeRangeSpec = timeRangeSpec;
    return this;
  }

  @Override
  public FutureResourcesSpec set(String fieldName, Object value) {
    return (FutureResourcesSpec) super.set(fieldName, value);
  }

  @Override
  public FutureResourcesSpec clone() {
    return (FutureResourcesSpec) super.clone();
  }

}
