/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for InterconnectAttachmentGroupsOperationalStatus.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InterconnectAttachmentGroupsOperationalStatus extends com.google.api.client.json.GenericJson {

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<InterconnectAttachmentGroupsOperationalStatusAttachmentStatus> attachmentStatuses;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InterconnectAttachmentGroupConfigured configured;

  /**
   * Summarizes the status of the group.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String groupStatus;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InterconnectAttachmentGroupIntent intent;

  /**
   * The operational state of the group, including only active Attachments.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InterconnectAttachmentGroupConfigured operational;

  /**
   * @return value or {@code null} for none
   */
  public java.util.List<InterconnectAttachmentGroupsOperationalStatusAttachmentStatus> getAttachmentStatuses() {
    return attachmentStatuses;
  }

  /**
   * @param attachmentStatuses attachmentStatuses or {@code null} for none
   */
  public InterconnectAttachmentGroupsOperationalStatus setAttachmentStatuses(java.util.List<InterconnectAttachmentGroupsOperationalStatusAttachmentStatus> attachmentStatuses) {
    this.attachmentStatuses = attachmentStatuses;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public InterconnectAttachmentGroupConfigured getConfigured() {
    return configured;
  }

  /**
   * @param configured configured or {@code null} for none
   */
  public InterconnectAttachmentGroupsOperationalStatus setConfigured(InterconnectAttachmentGroupConfigured configured) {
    this.configured = configured;
    return this;
  }

  /**
   * Summarizes the status of the group.
   * @return value or {@code null} for none
   */
  public java.lang.String getGroupStatus() {
    return groupStatus;
  }

  /**
   * Summarizes the status of the group.
   * @param groupStatus groupStatus or {@code null} for none
   */
  public InterconnectAttachmentGroupsOperationalStatus setGroupStatus(java.lang.String groupStatus) {
    this.groupStatus = groupStatus;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public InterconnectAttachmentGroupIntent getIntent() {
    return intent;
  }

  /**
   * @param intent intent or {@code null} for none
   */
  public InterconnectAttachmentGroupsOperationalStatus setIntent(InterconnectAttachmentGroupIntent intent) {
    this.intent = intent;
    return this;
  }

  /**
   * The operational state of the group, including only active Attachments.
   * @return value or {@code null} for none
   */
  public InterconnectAttachmentGroupConfigured getOperational() {
    return operational;
  }

  /**
   * The operational state of the group, including only active Attachments.
   * @param operational operational or {@code null} for none
   */
  public InterconnectAttachmentGroupsOperationalStatus setOperational(InterconnectAttachmentGroupConfigured operational) {
    this.operational = operational;
    return this;
  }

  @Override
  public InterconnectAttachmentGroupsOperationalStatus set(String fieldName, Object value) {
    return (InterconnectAttachmentGroupsOperationalStatus) super.set(fieldName, value);
  }

  @Override
  public InterconnectAttachmentGroupsOperationalStatus clone() {
    return (InterconnectAttachmentGroupsOperationalStatus) super.clone();
  }

}
