/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Represents a License Code resource. A License Code is a unique identifier used to represent a
 * license resource. *Caution* This resource is intended for use only by third-party partners who
 * are creating Cloud Marketplace images.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LicenseCode extends com.google.api.client.json.GenericJson {

  /**
   * Specifies licenseCodes of licenses that can replace this license. Note: such replacements are
   * allowed even if removable_from_disk is false.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> allowedReplacementLicenses;

  /**
   * If true, this license can be appended to an existing disk's set of licenses.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean appendableToDisk;

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTimestamp;

  /**
   * [Output Only] Description of this License Code.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * Specifies licenseCodes of licenses that are incompatible with this license. If a license is
   * incompatible with this license, it cannot be attached to the same disk or image.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> incompatibleLicenses;

  /**
   * [Output Only] Type of resource. Always compute#licenseCode for licenses.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * [Output Only] URL and description aliases of Licenses with the same License Code.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<LicenseCodeLicenseAlias> licenseAlias;

  /**
   * If set, this license will be unable to be removed or replaced once attached to a disk until the
   * minimum_retention period has passed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Duration minimumRetention;

  /**
   * If true, this license can only be used on VMs on multi tenant nodes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean multiTenantOnly;

  /**
   * [Output Only] Name of the resource. The name is 1-20 characters long and must be a valid 64 bit
   * integer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * If true, indicates this is an OS license. Only one OS license can be attached to a disk or
   * image at a time.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean osLicense;

  /**
   * If true, this license can be removed from a disk's set of licenses, with no replacement license
   * needed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean removableFromDisk;

  /**
   * Specifies the set of permissible coattached licenseCodes of licenses that satisfy the
   * coattachment requirement of this license. At least one license from the set must be attached to
   * the same disk or image as this license.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> requiredCoattachedLicenses;

  /**
   * [Output Only] Server-defined URL for the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * If true, this license can only be used on VMs on sole tenant nodes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean soleTenantOnly;

  /**
   * [Output Only] Current state of this License Code.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String state;

  /**
   * [Output Only] If true, the license will remain attached when creating images or snapshots from
   * disks. Otherwise, the license is not transferred.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean transferable;

  /**
   * [Output Only] Last update timestamp in RFC3339 text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String updateTimestamp;

  /**
   * Specifies licenseCodes of licenses that can replace this license. Note: such replacements are
   * allowed even if removable_from_disk is false.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getAllowedReplacementLicenses() {
    return allowedReplacementLicenses;
  }

  /**
   * Specifies licenseCodes of licenses that can replace this license. Note: such replacements are
   * allowed even if removable_from_disk is false.
   * @param allowedReplacementLicenses allowedReplacementLicenses or {@code null} for none
   */
  public LicenseCode setAllowedReplacementLicenses(java.util.List<java.lang.String> allowedReplacementLicenses) {
    this.allowedReplacementLicenses = allowedReplacementLicenses;
    return this;
  }

  /**
   * If true, this license can be appended to an existing disk's set of licenses.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAppendableToDisk() {
    return appendableToDisk;
  }

  /**
   * If true, this license can be appended to an existing disk's set of licenses.
   * @param appendableToDisk appendableToDisk or {@code null} for none
   */
  public LicenseCode setAppendableToDisk(java.lang.Boolean appendableToDisk) {
    this.appendableToDisk = appendableToDisk;
    return this;
  }

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @param creationTimestamp creationTimestamp or {@code null} for none
   */
  public LicenseCode setCreationTimestamp(java.lang.String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * [Output Only] Description of this License Code.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * [Output Only] Description of this License Code.
   * @param description description or {@code null} for none
   */
  public LicenseCode setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * @param id id or {@code null} for none
   */
  public LicenseCode setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * Specifies licenseCodes of licenses that are incompatible with this license. If a license is
   * incompatible with this license, it cannot be attached to the same disk or image.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getIncompatibleLicenses() {
    return incompatibleLicenses;
  }

  /**
   * Specifies licenseCodes of licenses that are incompatible with this license. If a license is
   * incompatible with this license, it cannot be attached to the same disk or image.
   * @param incompatibleLicenses incompatibleLicenses or {@code null} for none
   */
  public LicenseCode setIncompatibleLicenses(java.util.List<java.lang.String> incompatibleLicenses) {
    this.incompatibleLicenses = incompatibleLicenses;
    return this;
  }

  /**
   * [Output Only] Type of resource. Always compute#licenseCode for licenses.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output Only] Type of resource. Always compute#licenseCode for licenses.
   * @param kind kind or {@code null} for none
   */
  public LicenseCode setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * [Output Only] URL and description aliases of Licenses with the same License Code.
   * @return value or {@code null} for none
   */
  public java.util.List<LicenseCodeLicenseAlias> getLicenseAlias() {
    return licenseAlias;
  }

  /**
   * [Output Only] URL and description aliases of Licenses with the same License Code.
   * @param licenseAlias licenseAlias or {@code null} for none
   */
  public LicenseCode setLicenseAlias(java.util.List<LicenseCodeLicenseAlias> licenseAlias) {
    this.licenseAlias = licenseAlias;
    return this;
  }

  /**
   * If set, this license will be unable to be removed or replaced once attached to a disk until the
   * minimum_retention period has passed.
   * @return value or {@code null} for none
   */
  public Duration getMinimumRetention() {
    return minimumRetention;
  }

  /**
   * If set, this license will be unable to be removed or replaced once attached to a disk until the
   * minimum_retention period has passed.
   * @param minimumRetention minimumRetention or {@code null} for none
   */
  public LicenseCode setMinimumRetention(Duration minimumRetention) {
    this.minimumRetention = minimumRetention;
    return this;
  }

  /**
   * If true, this license can only be used on VMs on multi tenant nodes.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getMultiTenantOnly() {
    return multiTenantOnly;
  }

  /**
   * If true, this license can only be used on VMs on multi tenant nodes.
   * @param multiTenantOnly multiTenantOnly or {@code null} for none
   */
  public LicenseCode setMultiTenantOnly(java.lang.Boolean multiTenantOnly) {
    this.multiTenantOnly = multiTenantOnly;
    return this;
  }

  /**
   * [Output Only] Name of the resource. The name is 1-20 characters long and must be a valid 64 bit
   * integer.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * [Output Only] Name of the resource. The name is 1-20 characters long and must be a valid 64 bit
   * integer.
   * @param name name or {@code null} for none
   */
  public LicenseCode setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * If true, indicates this is an OS license. Only one OS license can be attached to a disk or
   * image at a time.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getOsLicense() {
    return osLicense;
  }

  /**
   * If true, indicates this is an OS license. Only one OS license can be attached to a disk or
   * image at a time.
   * @param osLicense osLicense or {@code null} for none
   */
  public LicenseCode setOsLicense(java.lang.Boolean osLicense) {
    this.osLicense = osLicense;
    return this;
  }

  /**
   * If true, this license can be removed from a disk's set of licenses, with no replacement license
   * needed.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getRemovableFromDisk() {
    return removableFromDisk;
  }

  /**
   * If true, this license can be removed from a disk's set of licenses, with no replacement license
   * needed.
   * @param removableFromDisk removableFromDisk or {@code null} for none
   */
  public LicenseCode setRemovableFromDisk(java.lang.Boolean removableFromDisk) {
    this.removableFromDisk = removableFromDisk;
    return this;
  }

  /**
   * Specifies the set of permissible coattached licenseCodes of licenses that satisfy the
   * coattachment requirement of this license. At least one license from the set must be attached to
   * the same disk or image as this license.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getRequiredCoattachedLicenses() {
    return requiredCoattachedLicenses;
  }

  /**
   * Specifies the set of permissible coattached licenseCodes of licenses that satisfy the
   * coattachment requirement of this license. At least one license from the set must be attached to
   * the same disk or image as this license.
   * @param requiredCoattachedLicenses requiredCoattachedLicenses or {@code null} for none
   */
  public LicenseCode setRequiredCoattachedLicenses(java.util.List<java.lang.String> requiredCoattachedLicenses) {
    this.requiredCoattachedLicenses = requiredCoattachedLicenses;
    return this;
  }

  /**
   * [Output Only] Server-defined URL for the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * [Output Only] Server-defined URL for the resource.
   * @param selfLink selfLink or {@code null} for none
   */
  public LicenseCode setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * If true, this license can only be used on VMs on sole tenant nodes.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSoleTenantOnly() {
    return soleTenantOnly;
  }

  /**
   * If true, this license can only be used on VMs on sole tenant nodes.
   * @param soleTenantOnly soleTenantOnly or {@code null} for none
   */
  public LicenseCode setSoleTenantOnly(java.lang.Boolean soleTenantOnly) {
    this.soleTenantOnly = soleTenantOnly;
    return this;
  }

  /**
   * [Output Only] Current state of this License Code.
   * @return value or {@code null} for none
   */
  public java.lang.String getState() {
    return state;
  }

  /**
   * [Output Only] Current state of this License Code.
   * @param state state or {@code null} for none
   */
  public LicenseCode setState(java.lang.String state) {
    this.state = state;
    return this;
  }

  /**
   * [Output Only] If true, the license will remain attached when creating images or snapshots from
   * disks. Otherwise, the license is not transferred.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getTransferable() {
    return transferable;
  }

  /**
   * [Output Only] If true, the license will remain attached when creating images or snapshots from
   * disks. Otherwise, the license is not transferred.
   * @param transferable transferable or {@code null} for none
   */
  public LicenseCode setTransferable(java.lang.Boolean transferable) {
    this.transferable = transferable;
    return this;
  }

  /**
   * [Output Only] Last update timestamp in RFC3339 text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getUpdateTimestamp() {
    return updateTimestamp;
  }

  /**
   * [Output Only] Last update timestamp in RFC3339 text format.
   * @param updateTimestamp updateTimestamp or {@code null} for none
   */
  public LicenseCode setUpdateTimestamp(java.lang.String updateTimestamp) {
    this.updateTimestamp = updateTimestamp;
    return this;
  }

  @Override
  public LicenseCode set(String fieldName, Object value) {
    return (LicenseCode) super.set(fieldName, value);
  }

  @Override
  public LicenseCode clone() {
    return (LicenseCode) super.clone();
  }

}
