/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Machine Image parameters
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MachineImageParams extends com.google.api.client.json.GenericJson {

  /**
   * Input only. [Input Only] Specifies the list of disk device names that must be excluded from the
   * new machine image.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> excludedDisks;

  /**
   * Input only. [Input Only] Specifies the list of disk device names that must be included with the
   * new machine image.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> includedDisks;

  /**
   * Input only. [Input Only] Specifies the list of disk device names that must be excluded from the
   * new machine image.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getExcludedDisks() {
    return excludedDisks;
  }

  /**
   * Input only. [Input Only] Specifies the list of disk device names that must be excluded from the
   * new machine image.
   * @param excludedDisks excludedDisks or {@code null} for none
   */
  public MachineImageParams setExcludedDisks(java.util.List<java.lang.String> excludedDisks) {
    this.excludedDisks = excludedDisks;
    return this;
  }

  /**
   * Input only. [Input Only] Specifies the list of disk device names that must be included with the
   * new machine image.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getIncludedDisks() {
    return includedDisks;
  }

  /**
   * Input only. [Input Only] Specifies the list of disk device names that must be included with the
   * new machine image.
   * @param includedDisks includedDisks or {@code null} for none
   */
  public MachineImageParams setIncludedDisks(java.util.List<java.lang.String> includedDisks) {
    this.includedDisks = includedDisks;
    return this;
  }

  @Override
  public MachineImageParams set(String fieldName, Object value) {
    return (MachineImageParams) super.set(fieldName, value);
  }

  @Override
  public MachineImageParams clone() {
    return (MachineImageParams) super.clone();
  }

}
