/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Contains output only fields. Use this sub-message for actual values set on Instance attributes as
 * compared to the value requested by the user (intent) in their instance CRUD calls.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ResourceStatus extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] Accelerators status show results of GPU scans. These scans are specialized
   * diagnostic tests designed to uncover latent manufacturing defects or other issues that could
   * potentially lead to data corruption or impede the customer's ability to efficiently execute GPU
   * workloads.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ResourceStatusAcceleratorStatus> acceleratorStatus;

  /**
   * [Output Only] Effective metadata is a field that consolidates project, zonal instance settings,
   * and instance-level predefined metadata keys to provide the overridden value for those metadata
   * keys at the instance level.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ResourceStatusEffectiveInstanceMetadata effectiveInstanceMetadata;

  /**
   * [Output Only] Contains last termination details why the instance was terminated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ResourceStatusLastInstanceTerminationDetails lastInstanceTerminationDetails;

  /**
   * [Output Only] The precise location of your instance within the zone's data center, including
   * the block, sub-block, and host. The field is formatted as follows: blockId/subBlockId/hostId.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String physicalHost;

  /**
   * [Output Only] A series of fields containing the global name of the Compute Engine cluster, as
   * well as the ID of the block, sub-block, and host on which the running instance is located.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ResourceStatusPhysicalHostTopology physicalHostTopology;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ResourceStatusScheduling scheduling;

  /**
   * [Output Only] Represents the status of the service integration specs defined by the user in
   * instance.serviceIntegrationSpecs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, ResourceStatusServiceIntegrationStatus> serviceIntegrationStatuses;

  /**
   * [Output Only] Details about the instance stopping state.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ResourceStatusShutdownDetails shutdownDetails;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UpcomingMaintenance upcomingMaintenance;

  /**
   * [Output Only] Accelerators status show results of GPU scans. These scans are specialized
   * diagnostic tests designed to uncover latent manufacturing defects or other issues that could
   * potentially lead to data corruption or impede the customer's ability to efficiently execute GPU
   * workloads.
   * @return value or {@code null} for none
   */
  public java.util.List<ResourceStatusAcceleratorStatus> getAcceleratorStatus() {
    return acceleratorStatus;
  }

  /**
   * [Output Only] Accelerators status show results of GPU scans. These scans are specialized
   * diagnostic tests designed to uncover latent manufacturing defects or other issues that could
   * potentially lead to data corruption or impede the customer's ability to efficiently execute GPU
   * workloads.
   * @param acceleratorStatus acceleratorStatus or {@code null} for none
   */
  public ResourceStatus setAcceleratorStatus(java.util.List<ResourceStatusAcceleratorStatus> acceleratorStatus) {
    this.acceleratorStatus = acceleratorStatus;
    return this;
  }

  /**
   * [Output Only] Effective metadata is a field that consolidates project, zonal instance settings,
   * and instance-level predefined metadata keys to provide the overridden value for those metadata
   * keys at the instance level.
   * @return value or {@code null} for none
   */
  public ResourceStatusEffectiveInstanceMetadata getEffectiveInstanceMetadata() {
    return effectiveInstanceMetadata;
  }

  /**
   * [Output Only] Effective metadata is a field that consolidates project, zonal instance settings,
   * and instance-level predefined metadata keys to provide the overridden value for those metadata
   * keys at the instance level.
   * @param effectiveInstanceMetadata effectiveInstanceMetadata or {@code null} for none
   */
  public ResourceStatus setEffectiveInstanceMetadata(ResourceStatusEffectiveInstanceMetadata effectiveInstanceMetadata) {
    this.effectiveInstanceMetadata = effectiveInstanceMetadata;
    return this;
  }

  /**
   * [Output Only] Contains last termination details why the instance was terminated.
   * @return value or {@code null} for none
   */
  public ResourceStatusLastInstanceTerminationDetails getLastInstanceTerminationDetails() {
    return lastInstanceTerminationDetails;
  }

  /**
   * [Output Only] Contains last termination details why the instance was terminated.
   * @param lastInstanceTerminationDetails lastInstanceTerminationDetails or {@code null} for none
   */
  public ResourceStatus setLastInstanceTerminationDetails(ResourceStatusLastInstanceTerminationDetails lastInstanceTerminationDetails) {
    this.lastInstanceTerminationDetails = lastInstanceTerminationDetails;
    return this;
  }

  /**
   * [Output Only] The precise location of your instance within the zone's data center, including
   * the block, sub-block, and host. The field is formatted as follows: blockId/subBlockId/hostId.
   * @return value or {@code null} for none
   */
  public java.lang.String getPhysicalHost() {
    return physicalHost;
  }

  /**
   * [Output Only] The precise location of your instance within the zone's data center, including
   * the block, sub-block, and host. The field is formatted as follows: blockId/subBlockId/hostId.
   * @param physicalHost physicalHost or {@code null} for none
   */
  public ResourceStatus setPhysicalHost(java.lang.String physicalHost) {
    this.physicalHost = physicalHost;
    return this;
  }

  /**
   * [Output Only] A series of fields containing the global name of the Compute Engine cluster, as
   * well as the ID of the block, sub-block, and host on which the running instance is located.
   * @return value or {@code null} for none
   */
  public ResourceStatusPhysicalHostTopology getPhysicalHostTopology() {
    return physicalHostTopology;
  }

  /**
   * [Output Only] A series of fields containing the global name of the Compute Engine cluster, as
   * well as the ID of the block, sub-block, and host on which the running instance is located.
   * @param physicalHostTopology physicalHostTopology or {@code null} for none
   */
  public ResourceStatus setPhysicalHostTopology(ResourceStatusPhysicalHostTopology physicalHostTopology) {
    this.physicalHostTopology = physicalHostTopology;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public ResourceStatusScheduling getScheduling() {
    return scheduling;
  }

  /**
   * @param scheduling scheduling or {@code null} for none
   */
  public ResourceStatus setScheduling(ResourceStatusScheduling scheduling) {
    this.scheduling = scheduling;
    return this;
  }

  /**
   * [Output Only] Represents the status of the service integration specs defined by the user in
   * instance.serviceIntegrationSpecs.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, ResourceStatusServiceIntegrationStatus> getServiceIntegrationStatuses() {
    return serviceIntegrationStatuses;
  }

  /**
   * [Output Only] Represents the status of the service integration specs defined by the user in
   * instance.serviceIntegrationSpecs.
   * @param serviceIntegrationStatuses serviceIntegrationStatuses or {@code null} for none
   */
  public ResourceStatus setServiceIntegrationStatuses(java.util.Map<String, ResourceStatusServiceIntegrationStatus> serviceIntegrationStatuses) {
    this.serviceIntegrationStatuses = serviceIntegrationStatuses;
    return this;
  }

  /**
   * [Output Only] Details about the instance stopping state.
   * @return value or {@code null} for none
   */
  public ResourceStatusShutdownDetails getShutdownDetails() {
    return shutdownDetails;
  }

  /**
   * [Output Only] Details about the instance stopping state.
   * @param shutdownDetails shutdownDetails or {@code null} for none
   */
  public ResourceStatus setShutdownDetails(ResourceStatusShutdownDetails shutdownDetails) {
    this.shutdownDetails = shutdownDetails;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public UpcomingMaintenance getUpcomingMaintenance() {
    return upcomingMaintenance;
  }

  /**
   * @param upcomingMaintenance upcomingMaintenance or {@code null} for none
   */
  public ResourceStatus setUpcomingMaintenance(UpcomingMaintenance upcomingMaintenance) {
    this.upcomingMaintenance = upcomingMaintenance;
    return this;
  }

  @Override
  public ResourceStatus set(String fieldName, Object value) {
    return (ResourceStatus) super.set(fieldName, value);
  }

  @Override
  public ResourceStatus clone() {
    return (ResourceStatus) super.clone();
  }

}
