/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * The properties of a wire group. These properties determine how a group of redundant wires are
 * created and managed.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class WireGroupProperties extends com.google.api.client.json.GenericJson {

  /**
   * The type of the wire group, one of the following: - WIRE: a single pseudowire over two
   * Interconnect connections with no redundancy. - REDUNDANT: two pseudowires over four
   * Interconnect connections, with two connections in one metro and two connections in another
   * metro. Each redundant pair of Interconnect connections spans both edge availability domains of
   * the metro. Each pseudowire connects Interconnect connections in matching edge availability
   * domains of the two metros. - BOX_AND_CROSS: four pseudowires over four Interconnect
   * connections, with two connections in one metro and two connections in another metro. Each
   * redundant pair of Interconnect connections spans both edge availability domains of the metro.
   * Two pseudowires connect Interconnect connections in matching edge availability domains of the
   * two metros. Two additional pseudowires connect the non-matching edge availability domains of
   * the two metros.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * The type of the wire group, one of the following: - WIRE: a single pseudowire over two
   * Interconnect connections with no redundancy. - REDUNDANT: two pseudowires over four
   * Interconnect connections, with two connections in one metro and two connections in another
   * metro. Each redundant pair of Interconnect connections spans both edge availability domains of
   * the metro. Each pseudowire connects Interconnect connections in matching edge availability
   * domains of the two metros. - BOX_AND_CROSS: four pseudowires over four Interconnect
   * connections, with two connections in one metro and two connections in another metro. Each
   * redundant pair of Interconnect connections spans both edge availability domains of the metro.
   * Two pseudowires connect Interconnect connections in matching edge availability domains of the
   * two metros. Two additional pseudowires connect the non-matching edge availability domains of
   * the two metros.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The type of the wire group, one of the following: - WIRE: a single pseudowire over two
   * Interconnect connections with no redundancy. - REDUNDANT: two pseudowires over four
   * Interconnect connections, with two connections in one metro and two connections in another
   * metro. Each redundant pair of Interconnect connections spans both edge availability domains of
   * the metro. Each pseudowire connects Interconnect connections in matching edge availability
   * domains of the two metros. - BOX_AND_CROSS: four pseudowires over four Interconnect
   * connections, with two connections in one metro and two connections in another metro. Each
   * redundant pair of Interconnect connections spans both edge availability domains of the metro.
   * Two pseudowires connect Interconnect connections in matching edge availability domains of the
   * two metros. Two additional pseudowires connect the non-matching edge availability domains of
   * the two metros.
   * @param type type or {@code null} for none
   */
  public WireGroupProperties setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public WireGroupProperties set(String fieldName, Object value) {
    return (WireGroupProperties) super.set(fieldName, value);
  }

  @Override
  public WireGroupProperties clone() {
    return (WireGroupProperties) super.clone();
  }

}
