/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Recommendation for single resources specification, to be created in the future.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FutureResourcesRecommendation extends com.google.api.client.json.GenericJson {

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String endTime;

  /**
   * The advised location for resource usage. When a zone, in format 'zones/'. If not set, it means
   * that no location is recommended - see other_locations for details.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String location;

  /**
   * List of locations in the request scope that were not recommended. Keys of the map are zones, in
   * format 'zones/'. The values are status information indicating the recommendation status.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, FutureResourcesRecommendationOtherLocation> otherLocations;

  /**
   * Unique id of the recommendation, a UUID string generated by the API.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String recommendationId;

  /**
   * Type of recommendation. Currently only FUTURE_RESERVATION is supported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String recommendationType;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String startTime;

  /**
   * @return value or {@code null} for none
   */
  public String getEndTime() {
    return endTime;
  }

  /**
   * @param endTime endTime or {@code null} for none
   */
  public FutureResourcesRecommendation setEndTime(String endTime) {
    this.endTime = endTime;
    return this;
  }

  /**
   * The advised location for resource usage. When a zone, in format 'zones/'. If not set, it means
   * that no location is recommended - see other_locations for details.
   * @return value or {@code null} for none
   */
  public java.lang.String getLocation() {
    return location;
  }

  /**
   * The advised location for resource usage. When a zone, in format 'zones/'. If not set, it means
   * that no location is recommended - see other_locations for details.
   * @param location location or {@code null} for none
   */
  public FutureResourcesRecommendation setLocation(java.lang.String location) {
    this.location = location;
    return this;
  }

  /**
   * List of locations in the request scope that were not recommended. Keys of the map are zones, in
   * format 'zones/'. The values are status information indicating the recommendation status.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, FutureResourcesRecommendationOtherLocation> getOtherLocations() {
    return otherLocations;
  }

  /**
   * List of locations in the request scope that were not recommended. Keys of the map are zones, in
   * format 'zones/'. The values are status information indicating the recommendation status.
   * @param otherLocations otherLocations or {@code null} for none
   */
  public FutureResourcesRecommendation setOtherLocations(java.util.Map<String, FutureResourcesRecommendationOtherLocation> otherLocations) {
    this.otherLocations = otherLocations;
    return this;
  }

  /**
   * Unique id of the recommendation, a UUID string generated by the API.
   * @return value or {@code null} for none
   */
  public java.lang.String getRecommendationId() {
    return recommendationId;
  }

  /**
   * Unique id of the recommendation, a UUID string generated by the API.
   * @param recommendationId recommendationId or {@code null} for none
   */
  public FutureResourcesRecommendation setRecommendationId(java.lang.String recommendationId) {
    this.recommendationId = recommendationId;
    return this;
  }

  /**
   * Type of recommendation. Currently only FUTURE_RESERVATION is supported.
   * @return value or {@code null} for none
   */
  public java.lang.String getRecommendationType() {
    return recommendationType;
  }

  /**
   * Type of recommendation. Currently only FUTURE_RESERVATION is supported.
   * @param recommendationType recommendationType or {@code null} for none
   */
  public FutureResourcesRecommendation setRecommendationType(java.lang.String recommendationType) {
    this.recommendationType = recommendationType;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public String getStartTime() {
    return startTime;
  }

  /**
   * @param startTime startTime or {@code null} for none
   */
  public FutureResourcesRecommendation setStartTime(String startTime) {
    this.startTime = startTime;
    return this;
  }

  @Override
  public FutureResourcesRecommendation set(String fieldName, Object value) {
    return (FutureResourcesRecommendation) super.set(fieldName, value);
  }

  @Override
  public FutureResourcesRecommendation clone() {
    return (FutureResourcesRecommendation) super.clone();
  }

}
