/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for FutureResourcesSpecSpecificSKUResources.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FutureResourcesSpecSpecificSKUResources extends com.google.api.client.json.GenericJson {

  /**
   * Size of the request, in instance count.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long instanceCount;

  /**
   * Local SSD partitions. You do not have to include SSD partitions that are built in the machine
   * type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<FutureResourcesSpecLocalSsdPartition> localSsdPartitions;

  static {
    // hack to force ProGuard to consider FutureResourcesSpecLocalSsdPartition used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(FutureResourcesSpecLocalSsdPartition.class);
  }

  /**
   * The machine type to use for instances that will use the reservation. This field only accepts
   * machine type names. e.g. n2-standard-4 and does not accept machine type full or partial url.
   * e.g. projects/my-l7ilb-project/zones/us-central1-a/machineTypes/n2-standard-4. Use for GPU
   * reservations.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String machineType;

  /**
   * Size of the request, in instance count.
   * @return value or {@code null} for none
   */
  public java.lang.Long getInstanceCount() {
    return instanceCount;
  }

  /**
   * Size of the request, in instance count.
   * @param instanceCount instanceCount or {@code null} for none
   */
  public FutureResourcesSpecSpecificSKUResources setInstanceCount(java.lang.Long instanceCount) {
    this.instanceCount = instanceCount;
    return this;
  }

  /**
   * Local SSD partitions. You do not have to include SSD partitions that are built in the machine
   * type.
   * @return value or {@code null} for none
   */
  public java.util.List<FutureResourcesSpecLocalSsdPartition> getLocalSsdPartitions() {
    return localSsdPartitions;
  }

  /**
   * Local SSD partitions. You do not have to include SSD partitions that are built in the machine
   * type.
   * @param localSsdPartitions localSsdPartitions or {@code null} for none
   */
  public FutureResourcesSpecSpecificSKUResources setLocalSsdPartitions(java.util.List<FutureResourcesSpecLocalSsdPartition> localSsdPartitions) {
    this.localSsdPartitions = localSsdPartitions;
    return this;
  }

  /**
   * The machine type to use for instances that will use the reservation. This field only accepts
   * machine type names. e.g. n2-standard-4 and does not accept machine type full or partial url.
   * e.g. projects/my-l7ilb-project/zones/us-central1-a/machineTypes/n2-standard-4. Use for GPU
   * reservations.
   * @return value or {@code null} for none
   */
  public java.lang.String getMachineType() {
    return machineType;
  }

  /**
   * The machine type to use for instances that will use the reservation. This field only accepts
   * machine type names. e.g. n2-standard-4 and does not accept machine type full or partial url.
   * e.g. projects/my-l7ilb-project/zones/us-central1-a/machineTypes/n2-standard-4. Use for GPU
   * reservations.
   * @param machineType machineType or {@code null} for none
   */
  public FutureResourcesSpecSpecificSKUResources setMachineType(java.lang.String machineType) {
    this.machineType = machineType;
    return this;
  }

  @Override
  public FutureResourcesSpecSpecificSKUResources set(String fieldName, Object value) {
    return (FutureResourcesSpecSpecificSKUResources) super.set(fieldName, value);
  }

  @Override
  public FutureResourcesSpecSpecificSKUResources clone() {
    return (FutureResourcesSpecSpecificSKUResources) super.clone();
  }

}
